package org.nakedobjects.plugins.remoting.shared.encoding.object.data;

import java.io.Serializable;

import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.remoting.shared.data.Data;

public class ObjectDataImpl implements ObjectData, Encodable, Serializable {
    private static final long serialVersionUID = 1L;
    private Data fieldContent[];
    private final Oid oid;
    private final boolean resolved;
    private final String type;
    private final Version version;

    public ObjectDataImpl(final Oid oid, final String type, final boolean resolved, final Version version) {
        this.oid = oid;
        this.type = type;
        this.resolved = resolved;
        this.version = version;
    }

    public ObjectDataImpl(final ByteDecoder decoder) {
        type = decoder.getString();
        oid = (Oid) decoder.getObject();
        version = (Version) decoder.getObject();
        resolved = decoder.getBoolean();
        fieldContent = (Data[]) decoder.getObjects();
    }

    public void encode(final ByteEncoder encoder) {
        encoder.add(type);
        encoder.add(oid);
        encoder.add(version);
        encoder.add(resolved);
        encoder.add(fieldContent);
    }

    public Data[] getFieldContent() {
        return fieldContent;
    }

    public Oid getOid() {
        return oid;
    }

    public String getType() {
        return type;
    }

    public Version getVersion() {
        return version;
    }

    public boolean hasCompleteData() {
        return resolved;
    }

    public void setFieldContent(final Data[] fieldContent) {
        this.fieldContent = fieldContent;
    }

    @Override
    public String toString() {
        final ToString str = new ToString(this);
        str.append("type", type);
        str.append("oid", oid);
        str.append("version", version);
        str.append(",fields=");
        for (int i = 0; fieldContent != null && i < fieldContent.length; i++) {
            if (i > 0) {
                str.append(";");
            }
            if (fieldContent[i] == null) {
                str.append("null");
            } else {
                final String name = fieldContent[i].getClass().getName();
                str.append(name.substring(name.lastIndexOf('.') + 1));
            }
        }
        return str.toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
