package org.nakedobjects.plugins.remoting.shared.encoding.object.data;

import org.nakedobjects.plugins.remoting.shared.data.Data;

public interface ServerActionResultData {

    /**
     * Return the Data for the result from executing the action.
     */
    Data getReturn();

    /**
     * Return the ObjectData for the target if it was persisited by the server.
     */
    ObjectData getPersistedTarget();

    /**
     * Return the ObjectDatas for any of the parameters (in the same seqence as passed to the server) if they
     * were was persisited by the server.
     */
    ObjectData[] getPersistedParameters();

    /**
     * Return the set of ObjectData for any objects that where changed by the server while executing the
     * action.
     */
    ObjectData[] getUpdates();

    ReferenceData[] getDisposed();

    /**
     * Return all messages created by the action.
     */
    String[] getMessages();

    /**
     * Return all warnings created by the action.
     */
    String[] getWarnings();
}
// Copyright (c) Naked Objects Group Ltd.
