package org.nakedobjects.plugins.remoting.shared.encoding.query;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.encoding.query.data.PersistenceQueryData;
import org.nakedobjects.plugins.remoting.shared.encoding.query.data.PersistenceQueryFindByPatternData;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryFindByPattern;

public class PersistenceQueryFindByPatternEncoder extends PersistenceQueryEncoderAbstract {

    public Class<?> getPersistenceQueryClass() {
        return PersistenceQueryFindByPattern.class;
    }
    
    public PersistenceQueryData encode(
    		final PersistenceQuery persistenceQuery) {
        final PersistenceQueryFindByPattern patternPersistenceQuery = downcast(persistenceQuery);
        final NakedObject pattern = patternPersistenceQuery.getPattern();
        final ObjectData objectData = encodeObject(pattern);
        return new PersistenceQueryFindByPatternData(patternPersistenceQuery.getSpecification(), objectData);
    }

    @Override
    protected PersistenceQuery doDecode(
            final NakedObjectSpecification specification,
            final PersistenceQueryData persistenceQueryData) {
        final ObjectData patternData = downcast(persistenceQueryData).getPatternData();
        final NakedObject patternObject = decodeObject(patternData);
        return new PersistenceQueryFindByPattern(specification, patternObject);
    }

	private PersistenceQueryFindByPattern downcast(
			final PersistenceQuery persistenceQuery) {
		return (PersistenceQueryFindByPattern) persistenceQuery;
	}

	private PersistenceQueryFindByPatternData downcast(
			final PersistenceQueryData persistenceQueryData) {
		return (PersistenceQueryFindByPatternData)persistenceQueryData;
	}


}

// Copyright (c) Naked Objects Group Ltd.
