package org.nakedobjects.plugins.remoting.shared.encoding.query;

import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.remoting.shared.encoding.query.data.PersistenceQueryData;
import org.nakedobjects.plugins.remoting.shared.encoding.query.data.PersistenceQueryFindByTitleData;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryFindByTitle;

public class PersistenceQueryFindByTitleEncoder extends PersistenceQueryEncoderAbstract {

    public Class<?> getPersistenceQueryClass() {
        return PersistenceQueryFindByTitle.class;
    }

    public PersistenceQueryData encode(
    		final PersistenceQuery persistenceQuery) {
        PersistenceQueryFindByTitle queryByTitle = downcast(persistenceQuery);
		return new PersistenceQueryFindByTitleData(
        		persistenceQuery.getSpecification(), 
        		queryByTitle.getTitle());
    }

    @Override
    protected PersistenceQuery doDecode(
            final NakedObjectSpecification specification,
            final PersistenceQueryData persistenceQueryData) {
        final String title = (downcast(persistenceQueryData)).getTitle();
        return new PersistenceQueryFindByTitle(specification, title);
    }

	private PersistenceQueryFindByTitle downcast(
			final PersistenceQuery persistenceQuery) {
		return (PersistenceQueryFindByTitle) persistenceQuery;
	}

	private PersistenceQueryFindByTitleData downcast(
			final PersistenceQueryData persistenceQueryData) {
		return (PersistenceQueryFindByTitleData) persistenceQueryData;
	}

}

// Copyright (c) Naked Objects Group Ltd.
