package org.nakedobjects.plugins.remoting.shared.data;

import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.data.DataFactory;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ClientActionResultData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.CollectionData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.EncodeableObjectData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.NullData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ReferenceData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ServerActionResultData;


public class DummyObjectDataFactory implements DataFactory {
    public ObjectData createObjectData(final String type, final Oid oid, final boolean hasCompleteData, final Version version) {
        return new DummyObjectData(oid, type, hasCompleteData, version);
    }

    public EncodeableObjectData createValueData(final String fullName, final String encodedValue) {
        return new DummyEncodeableObjectData(encodedValue, fullName);
    }

    public NullData createNullData(final String type) {
        return new DummyNullValue(type);
    }

    public IdentityData createIdentityData(final String type, final Oid oid, final Version version) {
        return new DummyReferenceData(oid, type, version);
    }

    public CollectionData createCollectionData(
            final String collectionType,
            final String elementType,
            final Oid oid,
            final ReferenceData[] elements,
            final boolean hasAllElements,
            final Version version) {
        return new DummyCollectionData(oid, collectionType, elementType, elements, version);
    }

    public ServerActionResultData createServerActionResultData(
            final Data result,
            final ObjectData[] updatesData,
            final ReferenceData[] disposed,
            final ObjectData persistedTarget,
            final ObjectData[] persistedParameters,
            final String[] messages,
            final String[] warnings) {
        return new DummyResultData(result, updatesData, disposed, persistedTarget, persistedParameters, messages, warnings);
    }

    public ClientActionResultData createClientActionResultData(
            final ReferenceData[] madePersistent,
            final Version[] changedVersion,
            final ObjectData[] updates) {
        return new DummyClientResultData(madePersistent, changedVersion, null);
    }
}
// Copyright (c) Naked Objects Group Ltd.
