/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.server;

import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.testspec.TestProxySpecification;
import org.nakedobjects.plugins.remoting.server.ServerFacadeImpl;
import org.nakedobjects.plugins.remoting.shared.data.DummyEncodeableObjectData;
import org.nakedobjects.plugins.remoting.shared.data.DummyReferenceData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.EncodeableObjectData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;
import org.nakedobjects.runtime.testsystem.ProxyJunit4TestCase;
import org.nakedobjects.runtime.testsystem.TestProxyAssociation;
import org.nakedobjects.runtime.testsystem.TestProxyVersion;

@RunWith(value=JMock.class)
public class ServerDistribution_ParseableAssociationsTest
extends ProxyJunit4TestCase {
    private Mockery mockery = new JUnit4Mockery();
    private ServerFacadeImpl server;
    private AuthenticationSession session;
    private DummyReferenceData movieData;
    private NakedObject object;
    private TestProxyAssociation nameField;
    private AuthenticationManager mockAuthenticationManager;
    private ObjectEncoder mockObjectEncoder;

    @Before
    public void setUp() throws Exception {
        this.mockAuthenticationManager = (AuthenticationManager)this.mockery.mock(AuthenticationManager.class);
        this.mockObjectEncoder = (ObjectEncoder)this.mockery.mock(ObjectEncoder.class);
        this.server = new ServerFacadeImpl(this.mockAuthenticationManager);
        this.server.setEncoder(this.mockObjectEncoder);
        this.server.init();
        this.object = this.system.createPersistentTestObject();
        TestProxySpecification spec = (TestProxySpecification)this.object.getSpecification();
        this.nameField = new TestProxyAssociation("name", this.system.getSpecification(String.class));
        spec.setupFields(new NakedObjectAssociation[]{this.nameField});
        this.movieData = new DummyReferenceData(this.object.getOid(), "none", (Version)new TestProxyVersion(1));
    }

    @After
    public void tearDown() throws Exception {
        this.system.shutdown();
    }

    @Test
    public void testClearAssociation() {
        NakedObjectsContext.getTransactionManager().startTransaction();
        ObjectData[] updatesData = this.server.clearValue(this.session, "name", (IdentityData)this.movieData);
        NakedObjectsContext.getTransactionManager().endTransaction();
        this.nameField.assertFieldEmpty(this.object);
        Assert.assertEquals((long)0L, (long)updatesData.length);
    }

    @Test
    public void testSetValue() {
        TestProxySpecification specf = this.system.getSpecification(String.class);
        specf.addFacet((Facet)new EncodeableFacet(){

            public String toEncodedString(NakedObject object) {
                return null;
            }

            public NakedObject fromEncodedString(String encodedData) {
                return ServerDistribution_ParseableAssociationsTest.getAdapterManager().adapterFor((Object)new String(encodedData));
            }

            public Class facetType() {
                return EncodeableFacet.class;
            }

            public FacetHolder getFacetHolder() {
                return null;
            }

            public void setFacetHolder(FacetHolder facetHolder) {
            }

            public boolean alwaysReplace() {
                return false;
            }

            public boolean isDerived() {
                return false;
            }

            public boolean isNoop() {
                return false;
            }

            public Facet getUnderlyingFacet() {
                return null;
            }

            public void setUnderlyingFacet(Facet underlyingFacet) {
                throw new UnsupportedOperationException();
            }
        });
        NakedObjectsContext.getTransactionManager().startTransaction();
        ObjectData[] updates = this.server.setValue(this.session, "name", (IdentityData)this.movieData, (EncodeableObjectData)new DummyEncodeableObjectData("name of movie"));
        NakedObjectsContext.getTransactionManager().endTransaction();
        this.nameField.assertField((Object)this.object, (Object)"name of movie");
        Assert.assertEquals((long)0L, (long)updates.length);
    }

    @Test
    public void testSetAssociationFailsWithNonCurrentTarget() {
        try {
            this.object.setOptimisticLock((Version)new TestProxyVersion(2));
            this.server.setValue(this.session, "name", (IdentityData)this.movieData, (EncodeableObjectData)new DummyEncodeableObjectData("name of movie"));
            Assert.fail();
        }
        catch (ConcurrencyException concurrencyException) {
            // empty catch block
        }
    }

    @Test
    public void testSetAssociationFailsWhenInvisible() {
        this.nameField.setUpIsVisible(false);
        try {
            this.server.setValue(this.session, "name", (IdentityData)this.movieData, (EncodeableObjectData)new DummyEncodeableObjectData("name of movie"));
            Assert.fail();
        }
        catch (NakedObjectException expected) {
            Assert.assertEquals((Object)"can't modify field as not visible or editable", (Object)expected.getMessage());
        }
    }

    @Test
    public void testSetAssociationFailsWhenUnavailable() {
        this.nameField.setUpIsUnusableFor(this.object);
        try {
            this.server.setValue(this.session, "name", (IdentityData)this.movieData, (EncodeableObjectData)new DummyEncodeableObjectData("test data"));
            Assert.fail();
        }
        catch (NakedObjectException expected) {
            Assert.assertEquals((Object)"can't modify field as not visible or editable", (Object)expected.getMessage());
        }
    }
}

