/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.client.facets;

import org.apache.log4j.Logger;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.facets.DecoratingFacet;
import org.nakedobjects.metamodel.facets.actions.executed.ExecutedFacet;
import org.nakedobjects.metamodel.facets.actions.invoke.ActionInvocationFacet;
import org.nakedobjects.metamodel.facets.actions.invoke.ActionInvocationFacetAbstract;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionParameter;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.data.KnownObjects;
import org.nakedobjects.plugins.remoting.shared.encoding.object.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.NullData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ReferenceData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ServerActionResultData;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActionInvocationFacetWrapProxy
extends ActionInvocationFacetAbstract
implements DecoratingFacet<ActionInvocationFacet> {
    private static final Logger LOG = Logger.getLogger(ActionInvocationFacetWrapProxy.class);
    private final ServerFacade connection;
    private final ObjectEncoder encoder;
    private final ActionInvocationFacet underlyingFacet;
    private final NakedObjectAction peer;

    public ActionInvocationFacetWrapProxy(ActionInvocationFacet underlyingFacet, ServerFacade connection, ObjectEncoder encoder, NakedObjectAction peer) {
        super(underlyingFacet.getFacetHolder());
        this.underlyingFacet = underlyingFacet;
        this.connection = connection;
        this.encoder = encoder;
        this.peer = peer;
    }

    public ActionInvocationFacet getDecoratedFacet() {
        return this.underlyingFacet;
    }

    public NakedObject invoke(NakedObject target, NakedObject[] parameters) {
        if (this.isToBeExecutedRemotely(target)) {
            return this.executeRemotely(target, parameters);
        }
        LOG.debug((Object)this.debug("execute locally", this.getIdentifier(), target, parameters));
        return this.underlyingFacet.invoke(target, parameters);
    }

    public NakedObjectSpecification getReturnType() {
        return this.underlyingFacet.getReturnType();
    }

    public NakedObjectSpecification getOnType() {
        return this.underlyingFacet.getOnType();
    }

    public Identifier getIdentifier() {
        return this.peer.getIdentifier();
    }

    private NakedObject executeRemotely(NakedObject targetAdapter, NakedObject[] parameters) {
        int i;
        ServerActionResultData result;
        KnownObjects knownObjects = new KnownObjects();
        Data[] parameterObjectData = this.parameterValues(parameters, knownObjects);
        LOG.debug((Object)this.debug("execute remotely", this.getIdentifier(), targetAdapter, parameters));
        ReferenceData targetReference = targetAdapter == null ? null : this.encoder.encodeActionTarget(targetAdapter, knownObjects);
        try {
            NakedObjectActionType type = NakedObjectActionConstants.USER;
            String name = this.getIdentifier().getClassName() + "#" + this.getIdentifier().getMemberName();
            result = this.connection.executeServerAction(ActionInvocationFacetWrapProxy.getAuthenticationSession(), type.getName(), name, targetReference, parameterObjectData);
        }
        catch (ConcurrencyException e) {
            Oid source = e.getSource();
            if (source == null) {
                throw e;
            }
            NakedObject failedObject = ActionInvocationFacetWrapProxy.getAdapterManager().getAdapterFor(source);
            ActionInvocationFacetWrapProxy.getPersistenceSession().reload(failedObject);
            LOG.info((Object)("concurrency conflict: " + e.getMessage()));
            throw new ConcurrencyException("Object automatically reloaded: " + failedObject.titleString(), (Throwable)e);
        }
        catch (NakedObjectException e) {
            LOG.error((Object)"remoting exception", (Throwable)e);
            throw e;
        }
        if (targetAdapter.isTransient()) {
            this.encoder.madePersistent(targetAdapter, result.getPersistedTarget());
        }
        NakedObjectActionParameter[] parameters2 = this.peer.getParameters();
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            if (!parameters2[i2].getSpecification().isObject()) continue;
            this.encoder.madePersistent(parameters[i2], result.getPersistedParameters()[i2]);
        }
        Data returned = result.getReturn();
        NakedObject returnedObject = returned instanceof NullData ? null : this.encoder.decode(returned);
        ObjectData[] updates = result.getUpdates();
        for (int i3 = 0; i3 < updates.length; ++i3) {
            LOG.debug((Object)("update " + updates[i3].getOid()));
            this.encoder.decode(updates[i3]);
        }
        ReferenceData[] disposed = result.getDisposed();
        for (int i4 = 0; i4 < disposed.length; ++i4) {
            Oid oid = disposed[i4].getOid();
            LOG.debug((Object)("disposed " + oid));
            NakedObject adapter = ActionInvocationFacetWrapProxy.getAdapterManager().getAdapterFor(oid);
            NakedObjectsContext.getUpdateNotifier().addDisposedObject(adapter);
        }
        String[] messages = result.getMessages();
        for (i = 0; i < messages.length; ++i) {
            NakedObjectsContext.getMessageBroker().addMessage(messages[i]);
        }
        messages = result.getWarnings();
        for (i = 0; i < messages.length; ++i) {
            NakedObjectsContext.getMessageBroker().addWarning(messages[i]);
        }
        return returnedObject;
    }

    private boolean isToBeExecutedRemotely(NakedObject targetAdapter) {
        boolean localOverride;
        ExecutedFacet facet = (ExecutedFacet)this.peer.getFacet(ExecutedFacet.class);
        boolean remoteOverride = facet.value() == ExecutedFacet.Where.REMOTELY;
        boolean bl = localOverride = facet.value() == ExecutedFacet.Where.LOCALLY;
        if (localOverride) {
            return false;
        }
        if (remoteOverride) {
            return true;
        }
        if (targetAdapter.getSpecification().isService()) {
            return true;
        }
        if (targetAdapter == null) {
            return false;
        }
        boolean remoteAsPersistent = targetAdapter.isPersistent();
        return remoteAsPersistent;
    }

    private Data[] parameterValues(NakedObject[] parameters, KnownObjects knownObjects) {
        NakedObjectSpecification[] parameterTypes = new NakedObjectSpecification[parameters.length];
        NakedObjectActionParameter[] parameters2 = this.peer.getParameters();
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = parameters[i].getSpecification();
        }
        return this.encoder.encodeActionParameters(parameterTypes, parameters, knownObjects);
    }

    private String debug(String message, Identifier identifier, NakedObject target, NakedObject[] parameters) {
        if (LOG.isDebugEnabled()) {
            StringBuffer str = new StringBuffer();
            str.append(message);
            str.append(" ");
            str.append(identifier);
            str.append(" on ");
            str.append(target);
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    str.append(',');
                }
                str.append(parameters[i]);
            }
            return str.toString();
        }
        return "";
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private static AdapterManager getAdapterManager() {
        return ActionInvocationFacetWrapProxy.getPersistenceSession().getAdapterManager();
    }

    private static AuthenticationSession getAuthenticationSession() {
        return NakedObjectsContext.getAuthenticationSession();
    }
}

