/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.client.facets;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.facets.DecoratingFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionAddToFacetAbstract;
import org.nakedobjects.plugins.remoting.client.facets.ProxyUtil;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.encoding.object.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionAddToFacetWrapProxy
extends CollectionAddToFacetAbstract
implements DecoratingFacet<CollectionAddToFacet> {
    private static final Logger LOG = Logger.getLogger(CollectionAddToFacetWrapProxy.class);
    private final ServerFacade connection;
    private final ObjectEncoder encoder;
    private final CollectionAddToFacet underlyingFacet;
    private final String name;

    public CollectionAddToFacetWrapProxy(CollectionAddToFacet underlyingFacet, ServerFacade connection, ObjectEncoder encoder, String name) {
        super(underlyingFacet.getFacetHolder());
        this.underlyingFacet = underlyingFacet;
        this.connection = connection;
        this.encoder = encoder;
        this.name = name;
    }

    public CollectionAddToFacet getDecoratedFacet() {
        return this.underlyingFacet;
    }

    public void add(NakedObject inObject, NakedObject referencedAdapter) {
        if (ProxyUtil.executeRemotely(inObject)) {
            try {
                IdentityData targetReference = this.encoder.encodeIdentityData(inObject);
                IdentityData associateReference = this.encoder.encodeIdentityData(referencedAdapter);
                ObjectData[] updates = this.connection.setAssociation(NakedObjectsContext.getAuthenticationSession(), this.name, targetReference, associateReference);
                ProxyUtil.updateChangedObjects(updates, this.encoder);
            }
            catch (ConcurrencyException e) {
                throw ProxyUtil.concurrencyException(e);
            }
            catch (NakedObjectException e) {
                LOG.error((Object)("remote exception: " + e.getMessage()), (Throwable)e);
                throw e;
            }
        } else {
            this.underlyingFacet.add(inObject, referencedAdapter);
        }
    }
}

