/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.client.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.plugins.remoting.client.persistence.ClientSideTransactionManager;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.encoding.object.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.encoding.query.data.PersistenceQueryData;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSessionAbstract;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactory;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryBuiltIn;
import org.nakedobjects.runtime.transaction.TransactionalClosure;
import org.nakedobjects.runtime.transaction.TransactionalClosureAbstract;
import org.nakedobjects.runtime.transaction.TransactionalClosureWithReturn;
import org.nakedobjects.runtime.transaction.TransactionalClosureWithReturnAbstract;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

public class PersistenceSessionProxy
extends PersistenceSessionAbstract {
    static final Logger LOG = Logger.getLogger(PersistenceSessionProxy.class);
    private ServerFacade connection;
    private ObjectEncoder encoder;
    private final Hashtable<NakedObjectSpecification, Object> cache = new Hashtable();
    private HashMap<String, Oid> services = new HashMap();

    public PersistenceSessionProxy(PersistenceSessionFactory persistenceSessionFactory, AdapterFactory adapterFactory, ObjectFactory objectFactory, ServicesInjector containerInjector, OidGenerator oidGenerator, AdapterManagerExtended identityMap, ServerFacade distribution, ObjectEncoder encoder) {
        super(persistenceSessionFactory, adapterFactory, objectFactory, containerInjector, oidGenerator, identityMap);
        this.setConnection(distribution);
        this.setEncoder(encoder);
    }

    public void doOpen() {
        this.connection.init();
    }

    public void doClose() {
        this.connection.shutdown();
    }

    public boolean isFixturesInstalled() {
        return true;
    }

    public void objectChanged(NakedObject adapter) {
        if (adapter.isTransient()) {
            this.getUpdateNotifier().addChangedObject(adapter);
        }
        if (adapter.getResolveState().respondToChangesInPersistentObjects()) {
            this.getClientSideTransactionManager().addObjectChanged(adapter);
        }
    }

    public synchronized void destroyObject(NakedObject object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("destroyObject " + object));
        }
        this.getClientSideTransactionManager().addDestroyObject(object);
    }

    public synchronized void makePersistent(NakedObject object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("makePersistent " + object));
        }
        this.getClientSideTransactionManager().addMakePersistent(object);
    }

    protected NakedObject[] getInstances(PersistenceQuery persistenceQuery) {
        NakedObjectSpecification noSpec = persistenceQuery.getSpecification();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getInstances of " + noSpec + " with " + persistenceQuery));
        }
        if (this.cache.containsKey(noSpec) && persistenceQuery instanceof PersistenceQueryBuiltIn) {
            PersistenceQueryBuiltIn builtIn = (PersistenceQueryBuiltIn)persistenceQuery;
            NakedObject collection = (NakedObject)this.cache.get(noSpec);
            if (collection.getSpecification().isCollection()) {
                CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
                ArrayList<NakedObject> instances = new ArrayList<NakedObject>();
                for (NakedObject instance : facet.iterable(collection)) {
                    if (!builtIn.matches(instance)) continue;
                    instances.add(instance);
                }
                return instances.toArray(new NakedObject[instances.size()]);
            }
        }
        return this.findInstancesFromServer(persistenceQuery);
    }

    private NakedObject[] findInstancesFromServer(PersistenceQuery persistenceQuery) {
        final PersistenceQueryData criteriaData = this.encoder.encodePersistenceQuery(persistenceQuery);
        return (NakedObject[])this.getTransactionManager().executeWithinTransaction((TransactionalClosureWithReturn)new TransactionalClosureWithReturnAbstract<NakedObject[]>(){

            public NakedObject[] execute() {
                ObjectData[] instancesAsObjectData = PersistenceSessionProxy.this.connection.findInstances(PersistenceSessionProxy.this.getAuthenticationSession(), criteriaData);
                NakedObject[] instances = new NakedObject[instancesAsObjectData.length];
                for (int i = 0; i < instancesAsObjectData.length; ++i) {
                    instances[i] = PersistenceSessionProxy.this.encoder.decode(instancesAsObjectData[i]);
                }
                return instances;
            }

            public void onSuccess() {
                PersistenceSessionProxy.this.clearAllDirty();
            }
        });
    }

    public boolean hasInstances(NakedObjectSpecification specification) {
        NakedObject collection;
        CollectionFacet facet;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("hasInstances of " + specification));
        }
        if (this.cache.containsKey(specification) && (facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)(collection = (NakedObject)this.cache.get(specification)))) != null) {
            return facet.size(collection) > 0;
        }
        return this.hasInstancesFromServer(specification);
    }

    private boolean hasInstancesFromServer(final NakedObjectSpecification specification) {
        return (Boolean)this.getTransactionManager().executeWithinTransaction((TransactionalClosureWithReturn)new TransactionalClosureWithReturnAbstract<Boolean>(){

            public Boolean execute() {
                return PersistenceSessionProxy.this.connection.hasInstances(PersistenceSessionProxy.this.getAuthenticationSession(), specification.getFullName());
            }
        });
    }

    public synchronized NakedObject loadObject(Oid oid, NakedObjectSpecification hint) {
        NakedObject adapter = this.getAdapterManager().getAdapterFor(oid);
        if (adapter != null) {
            return adapter;
        }
        return this.loadObjectFromServer(oid, hint);
    }

    private NakedObject loadObjectFromServer(final Oid oid, final NakedObjectSpecification hint) {
        return (NakedObject)this.getTransactionManager().executeWithinTransaction((TransactionalClosureWithReturn)new TransactionalClosureWithReturnAbstract<NakedObject>(){

            public NakedObject execute() {
                ObjectData data = PersistenceSessionProxy.this.connection.getObject(null, oid, hint.getFullName());
                return PersistenceSessionProxy.this.encoder.decode(data);
            }
        });
    }

    public void reload(NakedObject object) {
        IdentityData identityData = this.encoder.encodeIdentityData(object);
        this.reloadFromServer(identityData);
    }

    private void reloadFromServer(final IdentityData identityData) {
        this.getTransactionManager().executeWithinTransaction((TransactionalClosure)new TransactionalClosureAbstract(){

            public void execute() {
                ObjectData update = PersistenceSessionProxy.this.connection.resolveImmediately(PersistenceSessionProxy.this.getAuthenticationSession(), identityData);
                PersistenceSessionProxy.this.encoder.decode(update);
            }
        });
    }

    public synchronized void resolveImmediately(NakedObject adapter) {
        ResolveState resolveState = adapter.getResolveState();
        if (!resolveState.canChangeTo(ResolveState.RESOLVING)) {
            return;
        }
        Oid oid = adapter.getOid();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("resolve object (remotely from server)" + oid));
        }
        this.resolveImmediatelyFromServer(adapter);
    }

    private void resolveImmediatelyFromServer(final NakedObject adapter) {
        this.getTransactionManager().executeWithinTransaction((TransactionalClosure)new TransactionalClosureAbstract(){

            public void execute() {
                ObjectData data = PersistenceSessionProxy.this.connection.resolveImmediately(PersistenceSessionProxy.this.getAuthenticationSession(), PersistenceSessionProxy.this.encoder.encodeIdentityData(adapter));
                PersistenceSessionProxy.this.encoder.decode(data);
            }
        });
    }

    public void resolveField(NakedObject adapter, NakedObjectAssociation field) {
        if (field.getSpecification().isCollectionOrIsAggregated()) {
            return;
        }
        NakedObject referenceAdapter = field.get(adapter);
        if (referenceAdapter != null && referenceAdapter.getResolveState().isResolved()) {
            return;
        }
        if (referenceAdapter == null || !referenceAdapter.isPersistent()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("resolveField on server: " + adapter + "/" + field.getId()));
        }
        this.resolveFieldFromServer(adapter, field);
    }

    private void resolveFieldFromServer(final NakedObject adapter, final NakedObjectAssociation field) {
        this.getTransactionManager().executeWithinTransaction((TransactionalClosure)new TransactionalClosureAbstract(){

            public void execute() {
                Data data = PersistenceSessionProxy.this.connection.resolveField(PersistenceSessionProxy.this.getAuthenticationSession(), PersistenceSessionProxy.this.encoder.encodeIdentityData(adapter), field.getId());
                PersistenceSessionProxy.this.encoder.decode(data);
            }
        });
    }

    public Oid getOidForService(String name) {
        Oid oid = this.services.get(name);
        if (oid == null) {
            IdentityData data = this.connection.oidForService(this.getAuthenticationSession(), name);
            oid = data.getOid();
            this.registerService(name, oid);
        }
        return oid;
    }

    public void registerService(String name, Oid oid) {
        this.services.put(name, oid);
    }

    public void debugData(DebugString debug) {
        super.debugData(debug);
        debug.appendln("Connection", (Object)this.connection);
    }

    public String debugTitle() {
        return "Proxy Object Manager";
    }

    public void setCacheInstances(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            NakedObjectSpecification spec = NakedObjectsContext.getSpecificationLoader().loadSpecification(names[i]);
            this.cache.put(spec, Boolean.TRUE);
        }
    }

    public void setConnection(ServerFacade connection) {
        this.connection = connection;
    }

    public void setEncoder(ObjectEncoder factory) {
        this.encoder = factory;
    }

    private ClientSideTransactionManager getClientSideTransactionManager() {
        return (ClientSideTransactionManager)this.getTransactionManager();
    }

    private AuthenticationSession getAuthenticationSession() {
        return NakedObjectsContext.getAuthenticationSession();
    }

    private UpdateNotifier getUpdateNotifier() {
        return NakedObjectsContext.getUpdateNotifier();
    }
}

