/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.command.shared.requests;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.remoting.command.shared.requests.RequestAbstract;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ReferenceData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ServerActionResultData;

public class ExecuteServerAction
extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final String actionIdentifier;
    private final String actionType;
    private final Data[] parameters;
    private final ReferenceData target;

    public ExecuteServerAction(AuthenticationSession session, String actionType, String actionIdentifier, ReferenceData target, Data[] parameters) {
        super(session);
        this.actionType = actionType;
        this.actionIdentifier = actionIdentifier;
        this.target = target;
        this.parameters = parameters;
    }

    public ExecuteServerAction(ByteDecoder decoder) {
        super(decoder);
        this.actionIdentifier = decoder.getString();
        this.actionType = decoder.getString();
        this.target = (IdentityData)decoder.getObject();
        int size = decoder.getInt();
        this.parameters = new Data[size];
        for (int i = 0; i < size; ++i) {
            this.parameters[i] = (Data)decoder.getObject();
        }
    }

    protected void doEncode(ByteEncoder encoder) {
        encoder.add(this.actionIdentifier);
        encoder.add(this.actionType);
        encoder.add((Object)this.target);
        encoder.add(this.parameters.length);
        for (int i = 0; i < this.parameters.length; ++i) {
            encoder.add((Object)this.parameters[i]);
        }
    }

    public void execute(ServerFacade distribution) {
        this.setResponse(distribution.executeServerAction(this.session, this.actionType, this.actionIdentifier, this.target, this.parameters));
    }

    public ServerActionResultData getActionResult() {
        return (ServerActionResultData)this.getResponse();
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("method", this.actionIdentifier);
        str.append("target", (Object)this.target);
        return str.toString();
    }
}

