/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.command.transport.pipe.server;

import org.apache.log4j.Logger;
import org.nakedobjects.plugins.remoting.command.shared.requests.Request;
import org.nakedobjects.plugins.remoting.command.shared.requests.Response;
import org.nakedobjects.plugins.remoting.command.transport.pipe.shared.PipedConnection;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;

public class PipedServer {
    private static final Logger LOG = Logger.getLogger(PipedServer.class);
    private ServerFacade facade;
    private PipedConnection communication;

    public synchronized void run() {
        while (true) {
            Request request = this.communication.getRequest();
            LOG.debug((Object)("client request: " + request));
            try {
                request.execute(this.facade);
                Response response = new Response(request);
                LOG.debug((Object)("server response: " + response));
                this.communication.setResponse(response);
                continue;
            }
            catch (RuntimeException e) {
                this.communication.setException(e);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"failure during request", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void setConnection(PipedConnection communication) {
        this.communication = communication;
    }

    public void setFacade(ServerFacade facade) {
        this.facade = facade;
    }
}

