/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.command.transport.socket.shared;

import java.io.IOException;
import java.io.InputStream;

public class ProfilingInputStream
extends InputStream {
    private final InputStream wrapped;
    private int bytes = 0;
    private long end = 0L;
    private long start = 0L;

    public ProfilingInputStream(InputStream wrapped) {
        this.wrapped = wrapped;
    }

    private void end() {
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        }
        this.end = System.currentTimeMillis();
    }

    public int getSize() {
        return this.bytes;
    }

    public float getTime() {
        return (float)(this.end - this.start) / 1000.0f;
    }

    public int read() throws IOException {
        this.start();
        int read = this.wrapped.read();
        ++this.bytes;
        this.end();
        return read;
    }

    public int read(byte[] b) throws IOException {
        this.start();
        int read = this.wrapped.read(b);
        this.bytes += read;
        this.end();
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.start();
        int read = this.wrapped.read(b, off, len);
        this.bytes += read;
        this.end();
        return read;
    }

    public void resetTimer() {
        this.bytes = 0;
        this.end = 0L;
        this.start = 0L;
    }

    private void start() {
    }
}

