/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.remoting.server;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.exceptions.UnexpectedCallException;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectMember;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.metamodel.spec.identifier.IdentifierFactory;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.specloader.internal.NakedObjectActionImpl;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.plugins.remoting.shared.NakedObjectsRemoteException;
import org.nakedobjects.plugins.remoting.shared.ServerFacade;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.data.KnownObjects;
import org.nakedobjects.plugins.remoting.shared.encoding.object.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ClientActionResultData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.EncodeableObjectData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.NullData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ReferenceData;
import org.nakedobjects.plugins.remoting.shared.encoding.object.data.ServerActionResultData;
import org.nakedobjects.plugins.remoting.shared.encoding.query.data.PersistenceQueryData;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.PasswordAuthenticationRequest;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;
import org.nakedobjects.runtime.transaction.messagebroker.MessageBroker;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

public class ServerFacadeImpl
implements ServerFacade {
    private static final Logger LOG = Logger.getLogger(ServerFacadeImpl.class);
    private final AuthenticationManager authenticationManager;
    private ObjectEncoder encoder;

    public ServerFacadeImpl(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void init() {
    }

    public void shutdown() {
    }

    public void closeSession(AuthenticationSession session) {
        this.authenticationManager.closeSession(session);
    }

    public AuthenticationSession authenticate(String userNameAndPassword) {
        PasswordAuthenticationRequest request = this.extractAuthenticationRequest(userNameAndPassword);
        return this.authenticationManager.authenticate((AuthenticationRequest)request);
    }

    private PasswordAuthenticationRequest extractAuthenticationRequest(String userNameAndPassword) {
        int delimiter = userNameAndPassword.indexOf("::");
        String username = userNameAndPassword.substring(0, delimiter);
        String password = userNameAndPassword.substring(delimiter + 2);
        PasswordAuthenticationRequest request = new PasswordAuthenticationRequest(username, password);
        return request;
    }

    public boolean authoriseVisibility(AuthenticationSession session, String memberName) {
        return this.getMember(memberName).isVisible(session, null).isAllowed();
    }

    public boolean authoriseUsability(AuthenticationSession session, String memberName) {
        return this.getMember(memberName).isUsable(session, null).isAllowed();
    }

    private NakedObjectMember getMember(String memberName) {
        Identifier id = IdentifierFactory.fromIdentityString((String)memberName);
        NakedObjectSpecification specification = ServerFacadeImpl.getSpecificationLoader().loadSpecification(id.getClassName());
        if (id.isPropertyOrCollection()) {
            return this.getAssociationElseThrowException(id, specification);
        }
        return this.getActionElseThrowException(id, specification);
    }

    private NakedObjectMember getActionElseThrowException(Identifier id, NakedObjectSpecification specification) {
        NakedObjectAction member = specification.getObjectAction(NakedObjectActionConstants.USER, id.getMemberName(), this.getMemberParameterSpecifications(id));
        if (member == null) {
            throw new NakedObjectException("No user action found for id " + id);
        }
        return member;
    }

    private NakedObjectMember getAssociationElseThrowException(Identifier id, NakedObjectSpecification specification) {
        NakedObjectAssociation member = specification.getAssociation(id.getMemberName());
        if (member == null) {
            throw new NakedObjectException("No property or collection found for id " + id);
        }
        return member;
    }

    private NakedObjectSpecification[] getMemberParameterSpecifications(Identifier id) {
        String[] parameters = id.getMemberParameterNames();
        NakedObjectSpecification[] specifications = new NakedObjectSpecification[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            specifications[i] = ServerFacadeImpl.getSpecificationLoader().loadSpecification(parameters[i]);
        }
        return specifications;
    }

    public ObjectData[] setAssociation(AuthenticationSession session, String fieldIdentifier, IdentityData target, IdentityData associated) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request setAssociation " + fieldIdentifier + " on " + target + " with " + associated + " for " + session));
        }
        NakedObject inObject = this.getPersistentNakedObject(session, target);
        NakedObject associate = this.getPersistentNakedObject(session, associated);
        NakedObjectAssociation association = inObject.getSpecification().getAssociation(fieldIdentifier);
        if (!association.isVisible(session, inObject).isAllowed() || association.isUsable(session, inObject).isVetoed()) {
            throw new NakedObjectException("can't modify field as not visible or editable");
        }
        if (association instanceof OneToOneAssociation) {
            ((OneToOneAssociation)association).setAssociation(inObject, associate);
        } else {
            ((OneToManyAssociation)association).addElement(inObject, associate);
        }
        return this.getUpdates();
    }

    public ObjectData[] setValue(AuthenticationSession session, String fieldIdentifier, IdentityData target, EncodeableObjectData encodeableObjectData) {
        NakedObject inObject;
        OneToOneAssociation association;
        Assert.assertNotNull((Object)encodeableObjectData);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request setValue " + fieldIdentifier + " on " + target + " with " + encodeableObjectData + " for " + session));
        }
        if (!(association = (OneToOneAssociation)(inObject = this.getPersistentNakedObject(session, target)).getSpecification().getAssociation(fieldIdentifier)).isVisible(session, inObject).isAllowed() || association.isUsable(session, inObject).isVetoed()) {
            throw new NakedObjectException("can't modify field as not visible or editable");
        }
        String encodedObject = encodeableObjectData.getEncodedObjectData();
        NakedObjectSpecification specification = association.getSpecification();
        NakedObject adapter = this.restoreLeafObject(encodedObject, specification);
        association.setAssociation(inObject, adapter);
        return this.getUpdates();
    }

    public ObjectData[] clearAssociation(AuthenticationSession session, String fieldIdentifier, IdentityData target, IdentityData associated) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request clearAssociation " + fieldIdentifier + " on " + target + " of " + associated + " for " + session));
        }
        NakedObject inObject = this.getPersistentNakedObject(session, target);
        NakedObject associate = this.getPersistentNakedObject(session, associated);
        NakedObjectSpecification specification = inObject.getSpecification();
        NakedObjectAssociation association = specification.getAssociation(fieldIdentifier);
        if (!association.isVisible(session, inObject).isAllowed() || association.isUsable(session, inObject).isVetoed()) {
            throw new NakedObjectException("can't modify field as not visible or editable");
        }
        if (association instanceof OneToOneAssociation) {
            ((OneToOneAssociation)association).clearAssociation(inObject);
        } else {
            ((OneToManyAssociation)association).removeElement(inObject, associate);
        }
        return this.getUpdates();
    }

    public ObjectData[] clearValue(AuthenticationSession session, String fieldIdentifier, IdentityData target) {
        LOG.debug((Object)("request clearValue " + fieldIdentifier + " on " + target + " for " + session));
        NakedObject inObject = this.getPersistentNakedObject(session, target);
        OneToOneAssociation association = (OneToOneAssociation)inObject.getSpecification().getAssociation(fieldIdentifier);
        if (!association.isVisible(session, inObject).isAllowed() || association.isUsable(session, inObject).isVetoed()) {
            throw new NakedObjectException("can't modify field as not visible or editable");
        }
        association.clearAssociation(inObject);
        return this.getUpdates();
    }

    private ObjectData[] convertToNakedCollection(NakedObject instances) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)instances);
        ObjectData[] data = new ObjectData[facet.size(instances)];
        Enumeration elements = facet.elements(instances);
        int i = 0;
        while (elements.hasMoreElements()) {
            NakedObject element = (NakedObject)elements.nextElement();
            data[i++] = this.encoder.encodeCompletePersistentGraph(element);
        }
        return data;
    }

    public ClientActionResultData executeClientAction(AuthenticationSession session, ReferenceData[] data, int[] types) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("execute client action for " + session));
            LOG.debug((Object)"start transaction");
        }
        ServerFacadeImpl.getTransactionManager().startTransaction();
        try {
            KnownObjects knownObjects = new KnownObjects();
            NakedObject[] persistedObjects = new NakedObject[data.length];
            NakedObject[] disposedObjects = new NakedObject[data.length];
            NakedObject[] changedObjects = new NakedObject[data.length];
            block11: for (int i = 0; i < data.length; ++i) {
                switch (types[i]) {
                    case 1: {
                        NakedObject object;
                        persistedObjects[i] = object = this.encoder.decode(data[i], knownObjects);
                        if (!object.getOid().isTransient()) continue block11;
                        LOG.debug((Object)("  makePersistent " + data[i]));
                        ServerFacadeImpl.getPersistenceSession().makePersistent(object);
                        continue block11;
                    }
                    case 2: {
                        NakedObject obj = this.getPersistentNakedObject(data[i]);
                        obj.checkLock(data[i].getVersion());
                        NakedObject object = this.encoder.decode(data[i], knownObjects);
                        LOG.debug((Object)("  objectChanged " + data[i]));
                        ServerFacadeImpl.getPersistenceSession().objectChanged(object);
                        changedObjects[i] = object;
                        continue block11;
                    }
                    case 3: {
                        NakedObject inObject = this.getPersistentNakedObject(data[i]);
                        inObject.checkLock(data[i].getVersion());
                        LOG.debug((Object)("  destroyObject " + data[i] + " for " + session));
                        disposedObjects[i] = inObject;
                        ServerFacadeImpl.getPersistenceSession().destroyObject(inObject);
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"  end transaction");
            }
            ServerFacadeImpl.getTransactionManager().endTransaction();
            ReferenceData[] madePersistent = new ReferenceData[data.length];
            Version[] changedVersion = new Version[data.length];
            block12: for (int i = 0; i < data.length; ++i) {
                switch (types[i]) {
                    case 1: {
                        madePersistent[i] = this.encoder.encodeIdentityData(persistedObjects[i]);
                        continue block12;
                    }
                    case 2: {
                        changedVersion[i] = changedObjects[i].getVersion();
                    }
                }
            }
            return this.encoder.encodeClientActionResult(madePersistent, changedVersion, this.getUpdates());
        }
        catch (RuntimeException e) {
            LOG.info((Object)"abort transaction", (Throwable)e);
            ServerFacadeImpl.getTransactionManager().abortTransaction();
            throw e;
        }
    }

    public ServerActionResultData executeServerAction(AuthenticationSession session, String actionType, String actionIdentifier, ReferenceData target, Data[] parameterData) {
        NakedObject object;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request executeAction " + actionIdentifier + " on " + target + " for " + session));
        }
        KnownObjects knownObjects = new KnownObjects();
        if (target instanceof IdentityData) {
            object = this.getPersistentNakedObject(session, (IdentityData)target);
        } else if (target instanceof ObjectData) {
            object = this.encoder.decode(target, knownObjects);
        } else if (target == null) {
            object = null;
        } else {
            throw new NakedObjectException();
        }
        NakedObjectAction action = this.getActionMethod(actionType, actionIdentifier, parameterData, object);
        NakedObject[] parameters = this.getParameters(session, parameterData, knownObjects);
        if (action == null) {
            throw new NakedObjectsRemoteException("Could not find method " + actionIdentifier);
        }
        NakedObject result = action.execute(object, parameters);
        ObjectData persistedTarget = target == null ? null : (target instanceof ObjectData ? this.encoder.encodeMadePersistentGraph((ObjectData)target, object) : null);
        ObjectData[] persistedParameters = new ObjectData[parameterData.length];
        for (int i = 0; i < persistedParameters.length; ++i) {
            if (!action.getParameters()[i].getSpecification().isObject() || !(parameterData[i] instanceof ObjectData)) continue;
            persistedParameters[i] = this.encoder.encodeMadePersistentGraph((ObjectData)parameterData[i], parameters[i]);
        }
        List messages = this.getMessageBroker().getMessages();
        List warnings = this.getMessageBroker().getWarnings();
        return this.encoder.encodeServerActionResult(result, this.getUpdates(), this.getDisposed(), persistedTarget, persistedParameters, messages.toArray(new String[0]), warnings.toArray(new String[0]));
    }

    private MessageBroker getMessageBroker() {
        return NakedObjectsContext.getMessageBroker();
    }

    private NakedObjectAction getActionMethod(String actionType, String actionIdentifier, Data[] parameterData, NakedObject object) {
        NakedObjectSpecification[] parameterSpecifiactions = new NakedObjectSpecification[parameterData.length];
        for (int i = 0; i < parameterSpecifiactions.length; ++i) {
            parameterSpecifiactions[i] = this.getSpecification(parameterData[i].getType());
        }
        NakedObjectActionType type = NakedObjectActionImpl.getType((String)actionType);
        int pos = actionIdentifier.indexOf(35);
        String className = actionIdentifier.substring(0, pos);
        String methodName = actionIdentifier.substring(pos + 1);
        if (object == null) {
            throw new UnexpectedCallException("object not specified");
        }
        return object.getSpecification().getObjectAction(type, methodName, parameterSpecifiactions);
    }

    private NakedObject[] getParameters(AuthenticationSession session, Data[] parameterData, KnownObjects knownObjects) {
        NakedObject[] parameters = new NakedObject[parameterData.length];
        for (int i = 0; i < parameters.length; ++i) {
            Data data = parameterData[i];
            if (data instanceof NullData) continue;
            if (data instanceof IdentityData) {
                parameters[i] = this.getPersistentNakedObject(session, (IdentityData)data);
                continue;
            }
            if (data instanceof ObjectData) {
                parameters[i] = this.encoder.decode(data, knownObjects);
                continue;
            }
            if (data instanceof EncodeableObjectData) {
                NakedObject value;
                NakedObjectSpecification valueSpecification = ServerFacadeImpl.getSpecificationLoader().loadSpecification(data.getType());
                String valueData = ((EncodeableObjectData)data).getEncodedObjectData();
                parameters[i] = value = this.restoreLeafObject(valueData, valueSpecification);
                continue;
            }
            throw new UnknownTypeException((Object)data);
        }
        return parameters;
    }

    private ReferenceData[] getDisposed() {
        ArrayList<IdentityData> list = new ArrayList<IdentityData>();
        for (NakedObject element : ServerFacadeImpl.getUpdateNotifier().getDisposedObjects()) {
            list.add(this.encoder.encodeIdentityData(element));
        }
        return list.toArray(new ReferenceData[list.size()]);
    }

    public ObjectData getObject(AuthenticationSession session, Oid oid, String specificationName) {
        NakedObjectSpecification specification = this.getSpecification(specificationName);
        NakedObject object = ServerFacadeImpl.getPersistenceSession().loadObject(oid, specification);
        return this.encoder.encodeForUpdate(object);
    }

    public Data resolveField(AuthenticationSession session, IdentityData target, String fieldName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request resolveField " + target + "/" + fieldName + " for " + session));
        }
        NakedObjectSpecification spec = this.getSpecification(target.getType());
        NakedObjectAssociation field = spec.getAssociation(fieldName);
        NakedObject object = NakedObjectsContext.getPersistenceSession().recreateAdapter(target.getOid(), spec);
        ServerFacadeImpl.getPersistenceSession().resolveField(object, field);
        return this.encoder.encodeForResolveField(object, fieldName);
    }

    public ObjectData resolveImmediately(AuthenticationSession session, IdentityData target) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request resolveImmediately " + target + " for " + session));
        }
        NakedObjectSpecification spec = this.getSpecification(target.getType());
        NakedObject object = ServerFacadeImpl.getPersistenceSession().loadObject(target.getOid(), spec);
        if (object.getResolveState().canChangeTo(ResolveState.RESOLVING)) {
            ServerFacadeImpl.getPersistenceSession().resolveImmediately(object);
        }
        return this.encoder.encodeCompletePersistentGraph(object);
    }

    public ObjectData[] findInstances(AuthenticationSession session, PersistenceQueryData criteriaData) {
        PersistenceQuery criteria = this.encoder.decodePersistenceQuery(criteriaData);
        LOG.debug((Object)("request findInstances " + criteria + " for " + session));
        NakedObject instances = ServerFacadeImpl.getPersistenceSession().findInstances(criteria);
        return this.convertToNakedCollection(instances);
    }

    public boolean hasInstances(AuthenticationSession session, String objectType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request hasInstances of " + objectType + " for " + session));
        }
        return ServerFacadeImpl.getPersistenceSession().hasInstances(this.getSpecification(objectType));
    }

    public IdentityData oidForService(AuthenticationSession session, String id) {
        NakedObject service = ServerFacadeImpl.getPersistenceSession().getService(id);
        if (service == null) {
            throw new NakedObjectsRemoteException("Failed to find service " + id);
        }
        return this.encoder.encodeIdentityData(service);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.put("test-client", "true");
        NakedObjectConfiguration configuration = NakedObjectsContext.getConfiguration();
        NakedObjectConfiguration serviceProperties = configuration.getProperties("nakedobjects.services");
        Enumeration e = serviceProperties.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            properties.put(name, serviceProperties.getString(name));
        }
        String oidGeneratorClass = ServerFacadeImpl.getPersistenceSession().getOidGenerator().getClass().getName();
        if (oidGeneratorClass != null) {
            properties.put("nakedobjects.persistor.oid-generator", oidGeneratorClass);
        }
        return properties;
    }

    private NakedObjectSpecification getSpecification(String fullName) {
        return ServerFacadeImpl.getSpecificationLoader().loadSpecification(fullName);
    }

    private NakedObject getPersistentNakedObject(AuthenticationSession session, IdentityData object) {
        NakedObject obj = this.getPersistentNakedObject(object);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get object " + object + " for " + session + " --> " + obj));
        }
        obj.checkLock(object.getVersion());
        return obj;
    }

    private NakedObject getPersistentNakedObject(ReferenceData object) {
        NakedObjectSpecification spec = this.getSpecification(object.getType());
        NakedObject obj = ServerFacadeImpl.getPersistenceSession().loadObject(object.getOid(), spec);
        Assert.assertNotNull((Object)obj);
        return obj;
    }

    private NakedObject restoreLeafObject(String encodedObject, NakedObjectSpecification specification) {
        EncodeableFacet encoder = (EncodeableFacet)specification.getFacet(EncodeableFacet.class);
        if (encoder == null) {
            throw new NakedObjectException("No encoder for " + specification.getFullName());
        }
        NakedObject object = encoder.fromEncodedString(encodedObject);
        return object;
    }

    private ObjectData[] getUpdates() {
        ArrayList<ObjectData> list = new ArrayList<ObjectData>();
        for (NakedObject element : ServerFacadeImpl.getUpdateNotifier().getChangedObjects()) {
            list.add(this.encoder.encodeForUpdate(element));
        }
        return list.toArray(new ObjectData[list.size()]);
    }

    public void setEncoder(ObjectEncoder objectEncoder) {
        this.encoder = objectEncoder;
    }

    private static SpecificationLoader getSpecificationLoader() {
        return NakedObjectsContext.getSpecificationLoader();
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private static NakedObjectTransactionManager getTransactionManager() {
        return ServerFacadeImpl.getPersistenceSession().getTransactionManager();
    }

    private static UpdateNotifier getUpdateNotifier() {
        return NakedObjectsContext.getUpdateNotifier();
    }
}

