package org.nakedobjects.remoting.client.authentication;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.remoting.shared.ServerFacade;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.AuthenticationRequestPassword;
import org.nakedobjects.runtime.context.NakedObjectsContext;


public class AuthenticationManagerProxy implements AuthenticationManager {

    private final ServerFacade connection;
    private AuthenticationSession testSession;

    public AuthenticationManagerProxy(final ServerFacade connection) {
        Assert.assertNotNull("a connection must be set up", connection);
        this.connection = connection;
    }

    public void init() {}

    public void shutdown() {}


    public AuthenticationSession authenticate(final AuthenticationRequest request) {
        if (testSession != null) {
            return testSession;
        }
        final AuthenticationRequestPassword passwordRequest = (AuthenticationRequestPassword) request;
        final String username = passwordRequest.getName();
        if (username == null || username.equals("")) {
            return null;
        }
        final String password = passwordRequest.getPassword();
        if (password == null || password.equals("")) {
            return null;
        }

        return connection.authenticate(username + "::" + password);
    }

    public void closeSession(final AuthenticationSession session) {
        connection.closeSession(session);
        NakedObjectsContext.closeSession();
    }


    public boolean isSessionValid(AuthenticationSession session) {
        return true;
    }

    public void testSetSession(AuthenticationSession authenticationSession) {
        this.testSession = authenticationSession;
    }

}

// Copyright (c) Naked Objects Group Ltd.
