package org.nakedobjects.remoting.client.facetdecorator;

import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.facetdecorator.FacetDecoratorAbstract;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.actions.invoke.ActionInvocationFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.identifier.Identified;
import org.nakedobjects.remoting.client.facets.ActionInvocationFacetWrapProxy;
import org.nakedobjects.remoting.shared.ServerFacade;
import org.nakedobjects.remoting.shared.encoding.object.ObjectEncoder;
import org.nakedobjects.runtime.authorization.AuthorizationFacetDecorator;

public class ProxyFacetDecoratorFromRemotingCommandProject  extends FacetDecoratorAbstract {
	
    private final ServerFacade connection;
    private final ObjectEncoder encoder;
    @SuppressWarnings("unused")
	private final AuthorizationFacetDecorator authorisationFacetDecorator;

    // TODO complete for all facet type
    // TODO deal with security facet decoration
    public ProxyFacetDecoratorFromRemotingCommandProject(
            final ServerFacade connection,
            final ObjectEncoder encoder,
            final AuthorizationFacetDecorator securityFacetDecorator) {
        this.connection = connection;
        this.encoder = encoder;
        this.authorisationFacetDecorator = securityFacetDecorator;
    }

    public Facet decorate(final Facet facet, final FacetHolder holder) {
        if (!(holder instanceof Identified)) {
            return null;
        }
        Identified identified = (Identified) holder;
        @SuppressWarnings("unused")
		final Identifier identifier = identified.getIdentifier();
        
        final Class<? extends Facet> facetType = facet.facetType();
        @SuppressWarnings("unused")
		final FacetHolder facetHolder = facet.getFacetHolder();

        if (facetType == ActionInvocationFacet.class) {
            return new ActionInvocationFacetWrapProxy((ActionInvocationFacet) facet, connection, encoder,
                    (NakedObjectAction) holder);
        }

        return facet;
    }

    @SuppressWarnings("unchecked")
	public Class<? extends Facet>[] forFacetTypes() {
        return new Class[] { ActionInvocationFacet.class };
    }

}

// Copyright (c) Naked Objects Group Ltd.
