package org.nakedobjects.remoting.client.facets;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.remoting.shared.encoding.object.ObjectEncoder;
import org.nakedobjects.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;


public class ProxyUtil {
    private final static Logger LOG = Logger.getLogger(ProxyUtil.class);

    private ProxyUtil() {}

    public static ConcurrencyException concurrencyException(final ConcurrencyException e) {
        LOG.info("concurrency conflict: " + e.getMessage());
        final Oid source = e.getSource();
        if (source == null) {
            return e;
        } else {
            final NakedObject failedObject = getAdapterManager().getAdapterFor(source);
            getPersistenceSession().reload(failedObject);
            return new ConcurrencyException("Object automatically reloaded: " + failedObject.titleString(), e);
        }
    }

    public static void updateChangedObjects(final ObjectData[] updates, final ObjectEncoder encoder) {
        for (int i = 0; i < updates.length; i++) {
            LOG.debug("update " + updates[i].getOid());
            encoder.decode(updates[i]);
        }
    }

    public static boolean executeRemotely(final NakedObject targetAdapter) {
        return targetAdapter.isPersistent();
    }

    
    ///////////////////////////////////////////////////////////
    // Dependencies (from context)
    ///////////////////////////////////////////////////////////

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private static AdapterManager getAdapterManager() {
        return getPersistenceSession().getAdapterManager();
    }

}

// Copyright (c) Naked Objects Group Ltd.
