package org.nakedobjects.remoting.command.client.facetdecorator;

import org.nakedobjects.remoting.command.client.ServerFacadeProxy;
import org.nakedobjects.remoting.command.marshal.encoding.EncodingMarshaller;
import org.nakedobjects.remoting.command.transport.socket.CommandClientConnectionImpl;
import org.nakedobjects.remoting.shared.ServerFacade;


public class EncodingOnSocketsProxyDecoratorInstaller extends ProxyDecoratorInstallerAbstract {

    @Override
    protected ServerFacade createServerFacade() {
        EncodingMarshaller clientMarshaller = new EncodingMarshaller();
        CommandClientConnectionImpl connection = new CommandClientConnectionImpl(clientMarshaller);
        final ServerFacadeProxy serverFacade = new ServerFacadeProxy();
        serverFacade.setConnection(connection);
        return serverFacade;
    }

    public String getName() {
        return "encoding";
    }

}
// Copyright (c) Naked Objects Group Ltd.
