package org.nakedobjects.remoting.command.marshal.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.DebugByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.DebugByteEncoder;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.remoting.command.shared.marshal.MarshallerAbstract;
import org.nakedobjects.remoting.command.shared.requests.Request;


public class EncodingMarshaller extends MarshallerAbstract {
    
    private static final Logger LOG = Logger.getLogger(EncodingMarshaller.class);
    private ByteEncoder encoder;
    private ByteDecoder decoder;


    //////////////////////////////////////////////////////////////////
    // Common to both ClientMarshaller and ServerMarshaller
    //////////////////////////////////////////////////////////////////
    

    public void openStreams(final InputStream input, final OutputStream output) throws IOException {
        encoder = new DebugByteEncoder(output);
        decoder = new DebugByteDecoder(input);
    }

    //////////////////////////////////////////////////////////////////
    // ClientMarshaller impl
    //////////////////////////////////////////////////////////////////
    

    public Object request(final Request request) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sending request " + request);
        }
        try {
            write(request);
        } catch (final SocketException e) {
            getOwner().reconnect();
            write(request);
        }
        final Object object = decoder.getObject();
        if (LOG.isDebugEnabled()) {
            LOG.debug("response received: " + object);
        }
        decoder.end();
        return object;
    }

    private void write(final Request request) throws IOException {
        encoder.add(request.getClass().getName());
        request.encode(encoder);
        encoder.end();
    }

    
    //////////////////////////////////////////////////////////////////
    // ServerMarshaller impl
    //////////////////////////////////////////////////////////////////

    public Request awaitRequest() throws IOException {
        final Request request = (Request) decoder.getObject();
        if (LOG.isDebugEnabled()) {
            LOG.debug("request received: " + request);
        }
        decoder.end();
        return request;
    }

    public void sendError(final NakedObjectException exception) throws IOException {
        send(exception);
    }

    public void sendResponse(final Object response) throws IOException {
        send(response);
    }

    private void send(final Object object) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("send response: " + object);
        }
        encoder.add(object);
        encoder.end();
    }
    
    
}
// Copyright (c) Naked Objects Group Ltd.
