package org.nakedobjects.remoting.command.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.nakedobjects.remoting.command.marshal.serialize.SerializingMarshaller;
import org.nakedobjects.remoting.command.shared.marshal.ConnectionException;
import org.nakedobjects.remoting.command.transport.socket.SocketsViewerAbstract;
import org.nakedobjects.remoting.shared.ServerFacade;


public class SerializingOverSocketsViewer extends SocketsViewerAbstract {
    @Override
    protected ServerConnection createServerConnection(
            final InputStream input,
            final OutputStream output,
            final ServerFacade distribution) {
        SerializingMarshaller serverMarshaller = new SerializingMarshaller();
        try {
            serverMarshaller.openStreams(input, output);
        } catch (IOException e) {
            throw new ConnectionException(e);
        }
        return new ServerConnectionImpl(distribution, serverMarshaller);
    }
}

// Copyright (c) Naked Objects Group Ltd.
