package org.nakedobjects.remoting.command.shared.requests;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.remoting.shared.ServerFacade;

public class Authenticate extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final String data;

    public Authenticate(final String data) {
        super((AuthenticationSession) null);
        this.data = data;
    }

    @Override
    protected void doEncode(final ByteEncoder encoder) {}

    public void execute(final ServerFacade distribution) {
        setResponse(distribution.authenticate(data));
    }

    @Override
    public AuthenticationSession getSession() {
        return (AuthenticationSession) response;
    }

    @Override
    public String toString() {
        final ToString str = new ToString(this);
        str.append("sequence", getId());
        // TODO blank out data
        str.append("data", data);
        return str.toString();
    }

}

// Copyright (c) Naked Objects Group Ltd.
