package org.nakedobjects.remoting.command.shared.requests;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.remoting.shared.ServerFacade;

public class AuthoriseVisibility extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final String data;

    public AuthoriseVisibility(final AuthenticationSession session, final String data) {
        super(session);
        this.data = data;
    }

    @Override
    protected void doEncode(final ByteEncoder encoder) {}

    public void execute(final ServerFacade distribution) {
        setResponse(new Boolean(distribution.authoriseVisibility(session, data)));
    }

    public boolean getAuthorised() {
        return ((Boolean) response).booleanValue();
    }
}
