package org.nakedobjects.remoting.command.shared.requests;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.remoting.shared.ServerFacade;
import org.nakedobjects.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.remoting.shared.encoding.object.data.ObjectData;

public class ClearAssociation extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final String fieldIdentifier;
    private final IdentityData target;
    private final IdentityData associate;

    public ClearAssociation(
            final AuthenticationSession session,
            final String fieldIdentifier,
            final IdentityData target,
            final IdentityData associate) {
        super(session);
        this.fieldIdentifier = fieldIdentifier;
        this.target = target;
        this.associate = associate;
    }

    public ClearAssociation(final ByteDecoder decoder) {
        super(decoder);
        fieldIdentifier = decoder.getString();
        target = (IdentityData) decoder.getObject();
        associate = (IdentityData) decoder.getObject();
    }

    @Override
    protected void doEncode(final ByteEncoder encoder) {
        encoder.add(fieldIdentifier);
        encoder.add(target);
        encoder.add(associate);
    }

    public void execute(final ServerFacade distribution) {
        response = distribution.clearAssociation(session, fieldIdentifier, target, associate);
    }

    public ObjectData[] getChanges() {
        return (ObjectData[]) response;
    }
}
// Copyright (c) Naked Objects Group Ltd.
