package org.nakedobjects.remoting.command.shared.requests;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.remoting.shared.ServerFacade;
import org.nakedobjects.remoting.shared.data.Data;
import org.nakedobjects.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.remoting.shared.encoding.object.data.ReferenceData;
import org.nakedobjects.remoting.shared.encoding.object.data.ServerActionResultData;

public class ExecuteServerAction extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final String actionIdentifier;
    private final String actionType;
    private final Data[] parameters;
    private final ReferenceData target;

    public ExecuteServerAction(
            final AuthenticationSession session,
            final String actionType,
            final String actionIdentifier,
            final ReferenceData target,
            final Data[] parameters) {
        super(session);
        this.actionType = actionType;
        this.actionIdentifier = actionIdentifier;
        this.target = target;
        this.parameters = parameters;
    }

    public ExecuteServerAction(final ByteDecoder decoder) {
        super(decoder);
        actionIdentifier = decoder.getString();
        actionType = decoder.getString();
        target = (IdentityData) decoder.getObject();
        final int size = decoder.getInt();
        parameters = new Data[size];
        for (int i = 0; i < size; i++) {
            parameters[i] = (Data) decoder.getObject();
        }
    }

    @Override
    protected void doEncode(final ByteEncoder encoder) {
        encoder.add(actionIdentifier);
        encoder.add(actionType);
        encoder.add(target);
        encoder.add(parameters.length);
        for (int i = 0; i < parameters.length; i++) {
            encoder.add(parameters[i]);
        }
    }

    public void execute(final ServerFacade distribution) {
        setResponse(distribution.executeServerAction(session, actionType, actionIdentifier, target, parameters));
    }

    public ServerActionResultData getActionResult() {
        return (ServerActionResultData) getResponse();
    }

    @Override
    public String toString() {
        final ToString str = new ToString(this);
        str.append("method", actionIdentifier);
        str.append("target", target);
        return str.toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
