package org.nakedobjects.remoting.command.shared.requests;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.remoting.shared.ServerFacade;

public class HasInstances extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final String name;

    public HasInstances(final AuthenticationSession session, final String name) {
        super(session);
        this.name = name;
    }

    public HasInstances(final ByteDecoder decoder) {
        super(decoder);
        name = decoder.getString();
    }

    @Override
    protected void doEncode(final ByteEncoder encoder) {
        encoder.add(name);
    }

    public void execute(final ServerFacade distribution) {
        final boolean hasInstances = distribution.hasInstances(session, name);
        setResponse(new Boolean(hasInstances));
    }

    public boolean getFlag() {
        return ((Boolean) response).booleanValue();
    }

    @Override
    public String toString() {
        final ToString str = new ToString(this);
        str.append("class", name);
        return str.toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
