package org.nakedobjects.remoting.command.shared.requests;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.remoting.shared.ServerFacade;
import org.nakedobjects.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.remoting.shared.encoding.object.data.ObjectData;

public class Resolve extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final IdentityData target;

    public Resolve(final AuthenticationSession session, final IdentityData target) {
        super(session);
        this.target = target;
    }

    public Resolve(final ByteDecoder decoder) {
        super(decoder);
        target = (IdentityData) decoder.getObject();
    }

    @Override
    protected void doEncode(final ByteEncoder encoder) {
        encoder.add(target);
    }

    public void execute(final ServerFacade distribution) {
        setResponse(distribution.resolveImmediately(session, target));
    }

    public ObjectData getUpdateData() {
        return (ObjectData) getResponse();
    }

    @Override
    public String toString() {
        final ToString str = new ToString(this);
        str.append("target", target);
        return str.toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
