package org.nakedobjects.remoting.command.shared.util;

import org.nakedobjects.metamodel.commons.factory.InstanceFactory;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.remoting.command.shared.SharedConstants;
import org.nakedobjects.remoting.shared.encoding.object.ObjectEncoderDefault;
import org.nakedobjects.remoting.shared.encoding.query.PersistenceQueryEncoder;

/**
 * Factoring out logic common to client and server; might find a better place for it to
 * live later.
 */
public final class SharedUtil {
	
	private SharedUtil() {}

	public static ObjectEncoderDefault createDefaultEncoderAndAddCriteriaStrategies(
			final NakedObjectConfiguration configuration) {
		ObjectEncoderDefault encoder = createDefaultEncoder();
		addPersistenceEncoders(configuration, encoder);
		return encoder;
	}
	
	public static ObjectEncoderDefault createDefaultEncoder() {
		ObjectEncoderDefault encoder = new ObjectEncoderDefault();
		
		return encoder;
	}

	public static void addPersistenceEncoders(
			final NakedObjectConfiguration configuration,
			final ObjectEncoderDefault encoder) {
		addPersistenceEncoders(configuration, encoder, SharedConstants.ENCODER_CLASS_NAME_LIST);
		addPersistenceEncoders(configuration, encoder, SharedConstants.ENCODER_CLASS_NAME_LIST_DEPRECATED);
	}

	private static void addPersistenceEncoders(
			final NakedObjectConfiguration configuration,
			final ObjectEncoderDefault encoder, String encoderClassNameList) {
		String[] encoders = configuration.getList(encoderClassNameList);
	    for (int i = 0; i < encoders.length; i++) {
	        final PersistenceQueryEncoder encoding = InstanceFactory.createInstance(encoders[i], PersistenceQueryEncoder.class);
	        encoder.addPersistenceQueryEncoder(encoding);
	    }
	}

}
