package org.nakedobjects.remoting.command.transport.socket;

import org.nakedobjects.metamodel.config.ConfigurationConstants;

public final class SocketTransportConstants {
    
    public static final String REMOTE_HOST_KEY = ConfigurationConstants.ROOT + "remoting.command.port";
    public static final String REMOTE_HOST_DEFAULT = "localhost";
    
    public  static final String REMOTE_PORT_KEY = ConfigurationConstants.ROOT + "remoting.command.address";
    public static final int REMOTE_PORT_DEFAULT = 9567;
    
    public static final String REMOTE_DEBUGGING_KEY = ConfigurationConstants.ROOT + "remote.debugging";
    public static final boolean REMOTE_DEBUGGING_DEFAULT = true;
    
    public static final String REMOTE_KEEPALIVE_KEY = ConfigurationConstants.ROOT + "remote.keepalive";
    public static final boolean REMOTE_KEEPALIVE_DEFAULT = false;

    /**
     * REVIEW: as used by AbstractServerListener, with no prefix it would seem.  
     * 
     * <p>
     * Equivalent to {@link #REMOTE_PORT_KEY}.
     */
    public static final String SERVER_PORT = "server.port";

    private SocketTransportConstants() {}

}
