package org.nakedobjects.remoting.command.transport.socket;

import org.nakedobjects.remoting.command.shared.util.SharedUtil;
import org.nakedobjects.remoting.shared.encoding.object.ObjectEncoderDefault;
import org.nakedobjects.runtime.viewer.NakedObjectsViewer;
import org.nakedobjects.runtime.viewer.NakedObjectsViewerInstallerAbstract;

public abstract class SocketsViewerInstallerAbstract extends NakedObjectsViewerInstallerAbstract {

	@Override
    public NakedObjectsViewer doCreateViewer() {

        final SocketsViewerAbstract socketsViewer = createSocketsViewer();
        ObjectEncoderDefault encoder = SharedUtil.createDefaultEncoderAndAddCriteriaStrategies(getConfiguration());
		socketsViewer.setEncoder(encoder);

        return socketsViewer;
    }

    protected abstract SocketsViewerAbstract createSocketsViewer();

}
