package org.nakedobjects.remoting.shared;

import java.util.Properties;

import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.component.ApplicationScopedComponent;
import org.nakedobjects.remoting.shared.data.Data;
import org.nakedobjects.remoting.shared.encoding.object.data.ClientActionResultData;
import org.nakedobjects.remoting.shared.encoding.object.data.EncodeableObjectData;
import org.nakedobjects.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.remoting.shared.encoding.object.data.ReferenceData;
import org.nakedobjects.remoting.shared.encoding.object.data.ServerActionResultData;
import org.nakedobjects.remoting.shared.encoding.query.data.PersistenceQueryData;


/**
 * previously called <tt>Distribution</tt>.
 */
public interface ServerFacade extends ApplicationScopedComponent {

	
	///////////////////////////////////////////////////////////////////////
	// Authentication
	///////////////////////////////////////////////////////////////////////

    AuthenticationSession authenticate(String data);
    
    void closeSession(AuthenticationSession session);

    
	///////////////////////////////////////////////////////////////////////
	// Authorization
	///////////////////////////////////////////////////////////////////////

    boolean authoriseUsability(AuthenticationSession session, String data);

    boolean authoriseVisibility(AuthenticationSession session, String data);


	///////////////////////////////////////////////////////////////////////
	// Misc
	///////////////////////////////////////////////////////////////////////

    Properties getProperties();
    
	///////////////////////////////////////////////////////////////////////
	// Associations (Properties and Collections)
	///////////////////////////////////////////////////////////////////////

    ObjectData[] setAssociation(
    		AuthenticationSession session, 
    		String fieldIdentifier, IdentityData target, IdentityData associate);

	/**
	 * TODO remove the associate - clear the field without reference to its current state!
	 */
    ObjectData[] clearAssociation(
    		AuthenticationSession session, 
    		String fieldIdentifier, IdentityData target, IdentityData associate);

    ObjectData[] setValue(
    		AuthenticationSession session, 
    		String fieldIdentifier, IdentityData target, EncodeableObjectData value);

    ObjectData[] clearValue(
    		AuthenticationSession session, 
    		String fieldIdentifier, IdentityData target);

    
	///////////////////////////////////////////////////////////////////////
	// Actions
	///////////////////////////////////////////////////////////////////////

    ClientActionResultData executeClientAction(
    		AuthenticationSession session, 
    		ReferenceData[] changes, int types[]);

    ServerActionResultData executeServerAction(
            AuthenticationSession session,
            String actionType,
            String actionIdentifier,
            ReferenceData target,
            Data[] parameters);

    
	///////////////////////////////////////////////////////////////////////
	// getObject, resolve
	///////////////////////////////////////////////////////////////////////

    IdentityData oidForService(AuthenticationSession session, String id);

    ObjectData getObject(AuthenticationSession session, Oid oid, String specificationName);

    Data resolveField(AuthenticationSession session, IdentityData data, String fieldName);

    ObjectData resolveImmediately(AuthenticationSession session, IdentityData target);

    
	///////////////////////////////////////////////////////////////////////
	// findInstances, hasInstances
	///////////////////////////////////////////////////////////////////////

    ObjectData[] findInstances(AuthenticationSession session, PersistenceQueryData criteria);

    boolean hasInstances(AuthenticationSession session, String specificationName);

}
// Copyright (c) Naked Objects Group Ltd.
