package org.nakedobjects.remoting.shared.data;

import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.remoting.shared.encoding.object.data.ClientActionResultData;
import org.nakedobjects.remoting.shared.encoding.object.data.ClientActionResultDataImpl;
import org.nakedobjects.remoting.shared.encoding.object.data.CollectionData;
import org.nakedobjects.remoting.shared.encoding.object.data.CollectionDataImpl;
import org.nakedobjects.remoting.shared.encoding.object.data.EncodeableObjectData;
import org.nakedobjects.remoting.shared.encoding.object.data.EncodeableObjectDataImpl;
import org.nakedobjects.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.remoting.shared.encoding.object.data.IdentityDataImpl;
import org.nakedobjects.remoting.shared.encoding.object.data.NullData;
import org.nakedobjects.remoting.shared.encoding.object.data.NullDataImpl;
import org.nakedobjects.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.remoting.shared.encoding.object.data.ObjectDataImpl;
import org.nakedobjects.remoting.shared.encoding.object.data.ReferenceData;
import org.nakedobjects.remoting.shared.encoding.object.data.ServerActionResultData;
import org.nakedobjects.remoting.shared.encoding.object.data.ServerActionResultDataImpl;

public class DataFactoryImpl implements DataFactory {

    public CollectionData createCollectionData(
            final String collectionType,
            final String elementType,
            final Oid oid,
            final ReferenceData[] elements,
            final boolean hasAllElements,
            final Version version) {
        return new CollectionDataImpl(oid, collectionType, elementType, elements, hasAllElements, version);
    }

    public NullData createNullData(final String type) {
        return new NullDataImpl(type);
    }

    public ObjectData createObjectData(final String type, final Oid oid, final boolean hasCompleteData, final Version version) {
        return new ObjectDataImpl(oid, type, hasCompleteData, version);
    }

    public IdentityData createIdentityData(final String type, final Oid oid, final Version version) {
        return new IdentityDataImpl(type, oid, version);
    }

    public ServerActionResultData createServerActionResultData(
            final Data result,
            final ObjectData[] updatesData,
            final ReferenceData[] disposed,
            final ObjectData persistedTarget,
            final ObjectData[] persistedParameters,
            final String[] messages,
            final String[] warnings) {
        return new ServerActionResultDataImpl(result, updatesData, disposed, persistedTarget, persistedParameters, messages, warnings);
    }

    public EncodeableObjectData createValueData(final String type, final String encodedValue) {
        return new EncodeableObjectDataImpl(type, encodedValue);
    }

    public ClientActionResultData createClientActionResultData(
            final ReferenceData[] madePersistent,
            final Version[] changedVersion,
            final ObjectData[] updates) {
        return new ClientActionResultDataImpl(madePersistent, changedVersion, updates);
    }
}
// Copyright (c) Naked Objects Group Ltd.
