package org.nakedobjects.remoting.shared.encoding.object;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.remoting.shared.data.Data;
import org.nakedobjects.remoting.shared.data.KnownObjects;
import org.nakedobjects.remoting.shared.encoding.object.data.ClientActionResultData;
import org.nakedobjects.remoting.shared.encoding.object.data.EncodeableObjectData;
import org.nakedobjects.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.remoting.shared.encoding.object.data.ReferenceData;
import org.nakedobjects.remoting.shared.encoding.object.data.ServerActionResultData;
import org.nakedobjects.remoting.shared.encoding.query.data.PersistenceQueryData;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;

public interface ObjectEncoder {

	// ////////////////////////////////////////////////
	// Field Order
	// ////////////////////////////////////////////////

	/**
	 * Returns the agreed order to transfer fields within data objects. Both
	 * remote parties need to process the fields in the same order, this is that
	 * order.
	 */
	NakedObjectAssociation[] getFieldOrder(
			NakedObjectSpecification specification);

	// ////////////////////////////////////////////////
	// Identity
	// ////////////////////////////////////////////////

	IdentityData encodeIdentityData(NakedObject object);

	// ////////////////////////////////////////////////
	// Resolves
	// ////////////////////////////////////////////////

	Data encodeForResolveField(NakedObject object, String fieldName);

	// ////////////////////////////////////////////////
	// Actions & Parameters
	// ////////////////////////////////////////////////

	ReferenceData encodeActionTarget(NakedObject target,
			KnownObjects knownObjects);

	Data[] encodeActionParameters(NakedObjectSpecification[] parameterTypes,
			NakedObject[] parameters, KnownObjects knownObjects);

	ServerActionResultData encodeServerActionResult(NakedObject result,
			ObjectData[] updates, ReferenceData[] disposed,
			ObjectData persistedTarget, ObjectData[] persistedParameters,
			String[] messages, String[] warnings);

	ClientActionResultData encodeClientActionResult(
			ReferenceData[] madePersistent, Version[] changedVersion,
			ObjectData[] updates);

	// ////////////////////////////////////////////////
	// Graphs
	// ////////////////////////////////////////////////

	/**
	 * Creates an {@link ObjectData} that contains all the data for all the
	 * transient objects in the specified transient object.
	 * 
	 * <p>
	 * For any referenced persistent object in the graph, only the reference is
	 * passed across.
	 */
	ObjectData encodeMakePersistentGraph(NakedObject object,
			KnownObjects knownObjects);

	ObjectData encodeGraphForChangedObject(NakedObject object,
			KnownObjects knownObjects);

	/**
	 * Creates a a graph of ReferenceData objects (mirroring the graph of
	 * transient objects) to transfer the OIDs and Versions for each object that
	 * was made persistent during the makePersistent call.
	 */
	ObjectData encodeMadePersistentGraph(ObjectData data, NakedObject object);

	/**
	 * Creates an ObjectData that contains all the data for all the objects in
	 * the graph. This allows the client to receive all data it might need
	 * without having to return to the server to get referenced objects.
	 */
	ObjectData encodeCompletePersistentGraph(NakedObject object);

	// ////////////////////////////////////////////////
	// Value
	// ////////////////////////////////////////////////

	EncodeableObjectData encodeAsValue(NakedObject value);

	// ////////////////////////////////////////////////
	// Update
	// ////////////////////////////////////////////////

	/**
	 * Creates an {@link ObjectData} that contains the data for the specified
	 * object, but not the data for any referenced objects.
	 * 
	 * <p>
	 * For each referenced object only the reference is passed across.
	 */
	ObjectData encodeForUpdate(NakedObject object);

	// ////////////////////////////////////////////////
	// decode
	// ////////////////////////////////////////////////

	NakedObject decode(Data returned);

	NakedObject decode(Data data, KnownObjects knownObjects);

	// ////////////////////////////////////////////////
	// PersistenceQuery
	// ////////////////////////////////////////////////

	PersistenceQueryData encodePersistenceQuery(
			PersistenceQuery persistenceQuery);

	PersistenceQuery decodePersistenceQuery(
			PersistenceQueryData persistenceQueryData);

	// ////////////////////////////////////////////////
	// makePersistent
	// ////////////////////////////////////////////////

	void madePersistent(NakedObject target, ObjectData persistedTarget);

}

// Copyright (c) Naked Objects Group Ltd.
