package org.nakedobjects.remoting.shared.encoding.object.data;

import java.io.Serializable;

import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.remoting.shared.data.Data;

public class ServerActionResultDataImpl implements ServerActionResultData, Encodable, Serializable {
    private static final long serialVersionUID = 1L;
    private final Data result;
    private final ObjectData[] updatesData;
    private final ObjectData persistedTarget;
    private final ObjectData[] persistedParameters;
    private final String[] warnings;
    private final String[] messages;
    private final ReferenceData[] disposed;

    public ServerActionResultDataImpl(
            final Data result,
            final ObjectData[] updatesData,
            final ReferenceData[] disposed,
            final ObjectData persistedTarget,
            final ObjectData[] persistedParameters,
            final String[] messages,
            final String[] warnings) {
        this.result = result;
        this.updatesData = updatesData;
        this.disposed = disposed;
        this.persistedTarget = persistedTarget;
        this.persistedParameters = persistedParameters;
        this.messages = messages;
        this.warnings = warnings;
    }

    public ServerActionResultDataImpl(final ByteDecoder decoder) {
        result = (Data) decoder.getObject();
        messages = decoder.getList();
        warnings = decoder.getList();
        updatesData = (ObjectData[]) decoder.getObjects();
        disposed = (ReferenceData[]) decoder.getObjects();
        persistedTarget = (ObjectData) decoder.getObject();
        persistedParameters = (ObjectData[]) decoder.getObjects();
    }

    public void encode(final ByteEncoder encoder) {
        encoder.add(result);
        encoder.add(messages);
        encoder.add(warnings);
        encoder.add(updatesData);
        encoder.add(disposed);
        encoder.add(persistedTarget);
        encoder.add(persistedParameters);
    }

    public Data getReturn() {
        return result;
    }

    public ObjectData getPersistedTarget() {
        return persistedTarget;
    }

    public ObjectData[] getPersistedParameters() {
        return persistedParameters;
    }

    public ObjectData[] getUpdates() {
        return updatesData;
    }

    public ReferenceData[] getDisposed() {
        return disposed;
    }

    public String[] getMessages() {
        return messages;
    }

    public String[] getWarnings() {
        return warnings;
    }

}
// Copyright (c) Naked Objects Group Ltd.
