package org.nakedobjects.remoting.shared.encoding.query;

import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.remoting.command.shared.SharedConstants;
import org.nakedobjects.remoting.shared.encoding.object.ObjectEncoder;
import org.nakedobjects.remoting.shared.encoding.query.data.PersistenceQueryData;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;

/**
 * TODO: this would be a good candidate for genericizing.
 */
public interface PersistenceQueryEncoder {

    Class<?> getPersistenceQueryClass();
    
    /**
     * Injected directly after instantiation (note that encoders can potentially be loaded
     * reflectively, from the {@link NakedObjectConfiguration configuration} using the
     * {@value SharedConstants#ENCODER_CLASS_NAME_LIST} key.
     */
    void setObjectEncoder(ObjectEncoder objectEncoder);
    
    PersistenceQueryData encode(PersistenceQuery persistenceQuery);

    PersistenceQuery decode(PersistenceQueryData persistenceQueryData);
}

// Copyright (c) Naked Objects Group Ltd.
