package org.nakedobjects.remoting.shared.encoding.query.data;

import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryFindByPattern;

/**
 * Serializable representation of {@link PersistenceQueryFindByPattern}.
 */
public class PersistenceQueryFindByPatternData extends PersistenceQueryDataAbstract {
	
    private static final long serialVersionUID = 1L;
    private final ObjectData patternData;

    public PersistenceQueryFindByPatternData(
    		final NakedObjectSpecification noSpec, final ObjectData patternData) {
        super(noSpec);
        this.patternData = patternData;
    }

    public ObjectData getPatternData() {
        return patternData;
    }

    public Class<?> getPersistenceQueryClass() {
        return PersistenceQueryFindByPattern.class;
    }
}

// Copyright (c) Naked Objects Group Ltd.
