package org.nakedobjects.remoting.command.client;

import org.easymock.MockControl;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.remoting.command.client.CommandClientConnection;
import org.nakedobjects.remoting.command.client.ServerFacadeProxy;
import org.nakedobjects.remoting.command.shared.requests.Request;
import org.nakedobjects.remoting.command.shared.requests.RequestAbstract;
import org.nakedobjects.remoting.command.shared.requests.Response;
import org.nakedobjects.remoting.shared.NakedObjectsRemoteException;
import org.nakedobjects.remoting.shared.ServerFacade;
import org.nakedobjects.remoting.shared.data.DummyIdentityData;
import org.nakedobjects.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;
import org.nakedobjects.runtime.testsystem.TestProxyOid;
import org.nakedobjects.runtime.testsystem.TestProxySession;


public class CommandClientTest extends ProxyJunit3TestCase {
    private MockControl control;
    private ServerFacade distribution;
    private ServerFacadeProxy client;
    private TestProxySession session;

    @Override
    protected void setUp() throws Exception {
        super.setUp();

        control = MockControl.createControl(ServerFacade.class);
        distribution = (ServerFacade) control.getMock();
        client = new ServerFacadeProxy();
        client.setConnection(new CommandClientConnection() {
            public Response executeRemotely(final Request request) {
                request.execute(distribution);
                return new Response(request);
            }

            public void init() {}

            public void shutdown() {}
        });
        session = new TestProxySession();
    }

    public void testOidForService() {
        distribution.oidForService(session, "domain.Service");
        final Object data = new DummyIdentityData();
        control.setReturnValue(data);

        control.replay();
        final IdentityData ret = client.oidForService(session, "domain.Service");
        control.verify();

        assertEquals(data, ret);
    }

    public void testHasInstances() {
        distribution.hasInstances(session, "pkg.Class");
        final boolean data = true;
        control.setReturnValue(data);

        control.replay();
        final boolean ret = client.hasInstances(session, "pkg.Class");
        control.verify();

        assertEquals(data, ret);
    }

    public void testOutOfSequence() {
        client.setConnection(new CommandClientConnection() {
            public Response executeRemotely(final Request request) {
                // create a response based on another request so id is different
                return new Response(new RequestAbstract((AuthenticationSession) null) {
                    private static final long serialVersionUID = 1L;

                    public void execute(final ServerFacade distribution) {}

                    @Override
                    protected void doEncode(final ByteEncoder encoder) {}
                });
            }

            public void init() {}

            public void shutdown() {}
        });

        try {
            client.oidForService(session, "domain.Service");
            fail();
        } catch (final NakedObjectsRemoteException e) {
            assertTrue(e.getMessage().startsWith("Response out of sequence"));
        }
    }

    public void testClearAssociation() {
        final DummyIdentityData target = new DummyIdentityData(new TestProxyOid(1), "class 1", null);
        final DummyIdentityData associate = new DummyIdentityData(new TestProxyOid(2), "class 2", null);
        distribution.clearAssociation(session, "fieldname", target, associate);
        final Object data = new ObjectData[2];
        control.setReturnValue(data);

        control.replay();
        final ObjectData[] ret = client.clearAssociation(session, "fieldname", target, associate);
        control.verify();

        assertEquals(data, ret);
    }

}

// Copyright (c) Naked Objects Group Ltd.
