package org.nakedobjects.remoting.server;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.testspec.TestProxySpecification;
import org.nakedobjects.remoting.server.ServerFacadeImpl;
import org.nakedobjects.remoting.shared.data.DummyEncodeableObjectData;
import org.nakedobjects.remoting.shared.data.DummyReferenceData;
import org.nakedobjects.remoting.shared.encoding.object.ObjectEncoder;
import org.nakedobjects.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;
import org.nakedobjects.runtime.testsystem.ProxyJunit4TestCase;
import org.nakedobjects.runtime.testsystem.TestProxyAssociation;
import org.nakedobjects.runtime.testsystem.TestProxyVersion;


@RunWith(JMock.class)
public class ServerFacadeImpl_ParseableAssociationsTest extends ProxyJunit4TestCase {

    private Mockery mockery = new JUnit4Mockery();

    private ServerFacadeImpl server;
    private AuthenticationSession session;
    private DummyReferenceData movieData;
    private NakedObject object;
    private TestProxyAssociation nameField;

    private AuthenticationManager mockAuthenticationManager;
    private ObjectEncoder mockObjectEncoder;

    /*
     * Testing the Distribution implementation ServerDistribution. This uses the encoder to unmarshall objects
     * and then calls the persistor and reflector; all of which should be mocked.
     */
    @Before
    public void setUp() throws Exception {

        mockAuthenticationManager = mockery.mock(AuthenticationManager.class);
        mockObjectEncoder = mockery.mock(ObjectEncoder.class);

        server = new ServerFacadeImpl(mockAuthenticationManager);
        server.setEncoder(mockObjectEncoder);
        server.init();

        object = system.createPersistentTestObject();

        final TestProxySpecification spec = (TestProxySpecification) object.getSpecification();
        nameField = new TestProxyAssociation("name", system.getSpecification(String.class));
        spec.setupFields(new NakedObjectAssociation[] { nameField });

        movieData = new DummyReferenceData(object.getOid(), "none", new TestProxyVersion(1));

    }

    @After
    public void tearDown() throws Exception {
        system.shutdown();
    }

    /**
     * TODO: other tests for clear: - clear collection element - fails if unauthorised - fails if unavailable
     * 
     * <p>
     * could place all these clear test in one class; test other methods in other classes
     */
    @Test
    public void testClearAssociation() {
        NakedObjectsContext.getTransactionManager().startTransaction();
        final ObjectData[] updatesData = server.clearValue(session, "name", movieData);
        NakedObjectsContext.getTransactionManager().endTransaction();

        nameField.assertFieldEmpty(object);
        assertEquals(0, updatesData.length);
    }

    @Test
    public void testSetValue() {
        final TestProxySpecification specf = system.getSpecification(String.class);
        specf.addFacet(new EncodeableFacet() {
            public String toEncodedString(final NakedObject object) {
                return null;
            }

            public NakedObject fromEncodedString(final String encodedData) {
                return getAdapterManager().adapterFor(new String(encodedData));
            }

            public Class facetType() {
                return EncodeableFacet.class;
            }

            public FacetHolder getFacetHolder() {
                return null;
            }

            public void setFacetHolder(final FacetHolder facetHolder) {}

            public boolean alwaysReplace() {
                return false;
            }
            
            public boolean isDerived() {
            	return false;
            }

            public boolean isNoop() {
                return false;
            }
        	public Facet getUnderlyingFacet() {
        		return null;
        	}
        	public void setUnderlyingFacet(Facet underlyingFacet) {
        		throw new UnsupportedOperationException();
        	}

        });

        NakedObjectsContext.getTransactionManager().startTransaction();
        final ObjectData[] updates = server.setValue(session, "name", movieData, new DummyEncodeableObjectData("name of movie"));
        NakedObjectsContext.getTransactionManager().endTransaction();

        nameField.assertField(object, "name of movie");
        assertEquals(0, updates.length);
    }

    @Test
    public void testSetAssociationFailsWithNonCurrentTarget() {
        try {
            object.setOptimisticLock(new TestProxyVersion(2));
            server.setValue(session, "name", movieData, new DummyEncodeableObjectData("name of movie"));
            fail();
        } catch (final ConcurrencyException expected) {}
    }

    @Test
    public void testSetAssociationFailsWhenInvisible() {
        nameField.setUpIsVisible(false);
        try {
            server.setValue(session, "name", movieData, new DummyEncodeableObjectData("name of movie"));
            fail();
        } catch (final NakedObjectException expected) {
            assertEquals("can't modify field as not visible or editable", expected.getMessage());
        }
    }

    @Test
    public void testSetAssociationFailsWhenUnavailable() {
        nameField.setUpIsUnusableFor(object);
        try {
            server.setValue(session, "name", movieData, new DummyEncodeableObjectData("test data"));
            fail();
        } catch (final NakedObjectException expected) {
            assertEquals("can't modify field as not visible or editable", expected.getMessage());
        }
    }


}
// Copyright (c) Naked Objects Group Ltd.
