/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.command.client;

import org.easymock.MockControl;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.remoting.command.client.CommandClientConnection;
import org.nakedobjects.remoting.command.client.ServerFacadeProxy;
import org.nakedobjects.remoting.command.shared.requests.Request;
import org.nakedobjects.remoting.command.shared.requests.RequestAbstract;
import org.nakedobjects.remoting.command.shared.requests.Response;
import org.nakedobjects.remoting.shared.NakedObjectsRemoteException;
import org.nakedobjects.remoting.shared.ServerFacade;
import org.nakedobjects.remoting.shared.data.DummyIdentityData;
import org.nakedobjects.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;
import org.nakedobjects.runtime.testsystem.TestProxyOid;
import org.nakedobjects.runtime.testsystem.TestProxySession;

public class CommandClientTest
extends ProxyJunit3TestCase {
    private MockControl control;
    private ServerFacade distribution;
    private ServerFacadeProxy client;
    private TestProxySession session;

    protected void setUp() throws Exception {
        super.setUp();
        this.control = MockControl.createControl(ServerFacade.class);
        this.distribution = (ServerFacade)this.control.getMock();
        this.client = new ServerFacadeProxy();
        this.client.setConnection(new CommandClientConnection(){

            public Response executeRemotely(Request request) {
                request.execute(CommandClientTest.this.distribution);
                return new Response(request);
            }

            public void init() {
            }

            public void shutdown() {
            }
        });
        this.session = new TestProxySession();
    }

    public void testOidForService() {
        this.distribution.oidForService((AuthenticationSession)this.session, "domain.Service");
        DummyIdentityData data = new DummyIdentityData();
        this.control.setReturnValue((Object)data);
        this.control.replay();
        IdentityData ret = this.client.oidForService((AuthenticationSession)this.session, "domain.Service");
        this.control.verify();
        CommandClientTest.assertEquals((Object)data, (Object)ret);
    }

    public void testHasInstances() {
        this.distribution.hasInstances((AuthenticationSession)this.session, "pkg.Class");
        boolean data = true;
        this.control.setReturnValue((Object)true);
        this.control.replay();
        boolean ret = this.client.hasInstances((AuthenticationSession)this.session, "pkg.Class");
        this.control.verify();
        CommandClientTest.assertEquals((boolean)true, (boolean)ret);
    }

    public void testOutOfSequence() {
        this.client.setConnection(new CommandClientConnection(){

            public Response executeRemotely(Request request) {
                return new Response((Request)new RequestAbstract(null){
                    private static final long serialVersionUID = 1L;

                    public void execute(ServerFacade distribution) {
                    }

                    protected void doEncode(ByteEncoder encoder) {
                    }
                });
            }

            public void init() {
            }

            public void shutdown() {
            }
        });
        try {
            this.client.oidForService((AuthenticationSession)this.session, "domain.Service");
            CommandClientTest.fail();
        }
        catch (NakedObjectsRemoteException e) {
            CommandClientTest.assertTrue((boolean)e.getMessage().startsWith("Response out of sequence"));
        }
    }

    public void testClearAssociation() {
        DummyIdentityData target = new DummyIdentityData((Oid)new TestProxyOid(1), "class 1", null);
        DummyIdentityData associate = new DummyIdentityData((Oid)new TestProxyOid(2), "class 2", null);
        this.distribution.clearAssociation((AuthenticationSession)this.session, "fieldname", (IdentityData)target, (IdentityData)associate);
        ObjectData[] data = new ObjectData[2];
        this.control.setReturnValue((Object)data);
        this.control.replay();
        ObjectData[] ret = this.client.clearAssociation((AuthenticationSession)this.session, "fieldname", (IdentityData)target, (IdentityData)associate);
        this.control.verify();
        CommandClientTest.assertEquals((Object)data, (Object)ret);
    }
}

