/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.client.authorization;

import java.util.HashMap;
import java.util.Map;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.remoting.shared.ServerFacade;
import org.nakedobjects.runtime.authorization.AuthorizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyAuthorizationManager
implements AuthorizationManager {
    private final ServerFacade connection;
    private final Map<String, Boolean> visibilityCache = new HashMap<String, Boolean>();
    private final Map<String, Boolean> usabilityCache = new HashMap<String, Boolean>();

    public ProxyAuthorizationManager(ServerFacade connection) {
        this.connection = connection;
    }

    private boolean remoteAuthUsability(AuthenticationSession session, String idString) {
        return this.connection.authoriseUsability(session, idString);
    }

    private boolean remoteAuthVisibility(AuthenticationSession session, String idString) {
        return this.connection.authoriseVisibility(session, idString);
    }

    public boolean isUsable(AuthenticationSession session, Identifier identifier) {
        return this.isAuthorised(session, identifier, this.usabilityCache);
    }

    public boolean isVisible(AuthenticationSession session, Identifier identifier) {
        return this.isAuthorised(session, identifier, this.visibilityCache);
    }

    private boolean isAuthorised(AuthenticationSession session, Identifier identifier, Map<String, Boolean> cache) {
        String idString = identifier.toIdentityString(2);
        if (!cache.containsKey(idString)) {
            Boolean allow = cache == this.usabilityCache ? this.remoteAuthUsability(session, idString) : this.remoteAuthVisibility(session, idString);
            cache.put(idString, allow);
            return allow;
        }
        return cache.get(idString);
    }

    public void init() {
    }

    public void shutdown() {
    }
}

