/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.client.facets;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.facets.DecoratingFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionRemoveFromFacetAbstract;
import org.nakedobjects.remoting.client.facets.ProxyUtil;
import org.nakedobjects.remoting.shared.ServerFacade;
import org.nakedobjects.remoting.shared.encoding.object.ObjectEncoder;
import org.nakedobjects.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionRemoveFromFacetWrapProxy
extends CollectionRemoveFromFacetAbstract
implements DecoratingFacet<CollectionRemoveFromFacet> {
    private static final Logger LOG = Logger.getLogger(CollectionRemoveFromFacetWrapProxy.class);
    private final ServerFacade connection;
    private final ObjectEncoder encoder;
    private final CollectionRemoveFromFacet underlyingFacet;
    private final String name;

    public CollectionRemoveFromFacetWrapProxy(CollectionRemoveFromFacet underlyingFacet, ServerFacade connection, ObjectEncoder encoder, String name) {
        super(underlyingFacet.getFacetHolder());
        this.underlyingFacet = underlyingFacet;
        this.connection = connection;
        this.encoder = encoder;
        this.name = name;
    }

    public CollectionRemoveFromFacet getDecoratedFacet() {
        return this.underlyingFacet;
    }

    public void remove(NakedObject inObject, NakedObject associate) {
        if (ProxyUtil.executeRemotely(inObject)) {
            LOG.debug((Object)("clear association remotely " + inObject + "/" + associate));
            try {
                IdentityData targetReference = this.encoder.encodeIdentityData(inObject);
                IdentityData associateReference = this.encoder.encodeIdentityData(associate);
                ObjectData[] updates = this.connection.clearAssociation(NakedObjectsContext.getAuthenticationSession(), this.name, targetReference, associateReference);
                ProxyUtil.updateChangedObjects(updates, this.encoder);
            }
            catch (ConcurrencyException e) {
                throw ProxyUtil.concurrencyException(e);
            }
            catch (NakedObjectException e) {
                LOG.error((Object)("remote exception: " + e.getMessage()), (Throwable)e);
                throw e;
            }
        } else {
            LOG.debug((Object)("clear association locally " + inObject + "/" + associate));
            this.underlyingFacet.remove(inObject, associate);
        }
    }
}

