/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.client.facets;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.remoting.shared.encoding.object.ObjectEncoder;
import org.nakedobjects.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;

public class ProxyUtil {
    private static final Logger LOG = Logger.getLogger(ProxyUtil.class);

    private ProxyUtil() {
    }

    public static ConcurrencyException concurrencyException(ConcurrencyException e) {
        LOG.info((Object)("concurrency conflict: " + e.getMessage()));
        Oid source = e.getSource();
        if (source == null) {
            return e;
        }
        NakedObject failedObject = ProxyUtil.getAdapterManager().getAdapterFor(source);
        ProxyUtil.getPersistenceSession().reload(failedObject);
        return new ConcurrencyException("Object automatically reloaded: " + failedObject.titleString(), (Throwable)e);
    }

    public static void updateChangedObjects(ObjectData[] updates, ObjectEncoder encoder) {
        for (int i = 0; i < updates.length; ++i) {
            LOG.debug((Object)("update " + updates[i].getOid()));
            encoder.decode(updates[i]);
        }
    }

    public static boolean executeRemotely(NakedObject targetAdapter) {
        return targetAdapter.isPersistent();
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private static AdapterManager getAdapterManager() {
        return ProxyUtil.getPersistenceSession().getAdapterManager();
    }
}

