/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.command.marshal.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.remoting.command.shared.marshal.ConnectionException;
import org.nakedobjects.remoting.command.shared.marshal.IllegalRequestException;
import org.nakedobjects.remoting.command.shared.marshal.MarshallerAbstract;
import org.nakedobjects.remoting.command.shared.requests.Request;

public class SerializingMarshaller
extends MarshallerAbstract {
    private static final Logger LOG = Logger.getLogger(SerializingMarshaller.class);
    private ObjectInputStream input;
    private ObjectOutputStream output;

    public void openStreams(InputStream input, OutputStream output) throws IOException {
        input = new ObjectInputStream(input);
        output = new ObjectOutputStream(output);
    }

    public Object request(Request request) throws IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("sending request" + request));
            }
            try {
                this.output.writeObject(request);
            }
            catch (SocketException e) {
                this.getOwner().reconnect();
                this.output.writeObject(request);
            }
            this.output.flush();
            Object object = this.input.readObject();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("response received: " + object));
            }
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new ConnectionException("Failed request", e);
        }
    }

    public Request awaitRequest() throws IOException {
        try {
            Request request = (Request)this.input.readObject();
            return request;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalRequestException("unknown class received; closing connection: " + e.getMessage(), e);
        }
    }

    public void sendError(NakedObjectException exception) throws IOException {
        this.send((Object)exception);
    }

    public void sendResponse(Object response) throws IOException {
        this.send(response);
    }

    private void send(Object object) throws IOException {
        this.output.writeObject(object);
        this.output.flush();
    }
}

