/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.command.transport.socket;

import java.io.IOException;
import java.io.OutputStream;

public class ProfilingOutputStream
extends OutputStream {
    private final OutputStream wrapped;
    private int bytes = 0;
    private long end = 0L;
    private long start = 0L;

    public ProfilingOutputStream(OutputStream wrapped) {
        this.wrapped = wrapped;
    }

    private void end() {
        this.end = System.currentTimeMillis();
    }

    public int getSize() {
        return this.bytes;
    }

    public float getTime() {
        return (float)(this.end - this.start) / 1000.0f;
    }

    public void resetTimer() {
        this.bytes = 0;
        this.end = 0L;
        this.start = 0L;
    }

    private void start() {
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        }
    }

    public void write(byte[] b) throws IOException {
        this.start();
        this.bytes += b.length;
        this.wrapped.write(b);
        this.end();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.start();
        this.bytes += len;
        this.wrapped.write(b, off, len);
        this.end();
    }

    public void write(int b) throws IOException {
        this.start();
        ++this.bytes;
        this.wrapped.write(b);
        this.end();
    }
}

