/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.command.transport.socket;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.remoting.command.server.ServerConnection;
import org.nakedobjects.remoting.command.shared.requests.Authenticate;
import org.nakedobjects.remoting.command.shared.requests.Request;
import org.nakedobjects.remoting.command.shared.requests.Response;
import org.nakedobjects.remoting.command.transport.socket.WorkerPool;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.system.internal.monitor.Monitor;

public class Worker
implements Runnable {
    private static final Logger LOG = Logger.getLogger(Worker.class);
    private static final Logger ACCESS_LOG = Logger.getLogger((String)"access_log");
    private static int nextId = 1;
    private final WorkerPool poolToReturnTo;
    private final int id = nextId++;
    private ServerConnection connection;
    private String debugRequest;
    private String debugSession;
    private String debugResponse;
    private String debugContextId;
    private DebugInfo[] debugDetails;
    private long responseTime;
    private boolean running = true;

    public Worker(WorkerPool pool) {
        this.poolToReturnTo = pool;
    }

    public synchronized void gracefulStop() {
        this.running = false;
    }

    public synchronized void setConnection(ServerConnection connection) {
        this.connection = connection;
        this.notify();
    }

    public boolean isAvailable() {
        return this.connection == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        block14: while (this.running) {
            while (this.connection == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    if (this.running) continue;
                    LOG.info((Object)("Request to stop : " + this.toString()));
                    break block14;
                }
            }
            try {
                long start = System.currentTimeMillis();
                Request request = this.connection.awaitRequest();
                AuthenticationSession authenticationSession = null;
                try {
                    this.debugRequest = request.getId() + " - " + request.toString();
                    authenticationSession = request.getSession();
                    if (authenticationSession == null) {
                        this.debugSession = "(none)";
                        this.debugContextId = "(none)";
                        if (!(request instanceof Authenticate)) {
                            // empty if block
                        }
                    } else {
                        NakedObjectsContext.openSession((AuthenticationSession)authenticationSession);
                        this.debugSession = authenticationSession.toString();
                        this.debugContextId = NakedObjectsContext.getSessionId();
                        this.debugDetails = NakedObjectsContext.debugSession();
                    }
                    request.execute(this.connection.getServer());
                    Response response = new Response(request);
                    this.debugResponse = response.toString();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("sending " + this.debugResponse));
                    }
                    this.connection.sendResponse(response);
                    String message = "{" + authenticationSession.getUserName() + "|" + this + "}  " + request.toString();
                    ACCESS_LOG.info((Object)message);
                    Monitor.addEvent((String)"REQUEST", (String)message, (DebugInfo[])this.debugDetails);
                }
                catch (Exception e) {
                    LOG.error((Object)"error during remote request", (Throwable)e);
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    this.debugResponse = sw.toString();
                    this.connection.sendResponse(e);
                }
                finally {
                    if (authenticationSession != null) {
                        NakedObjectsContext.closeSession();
                    }
                    this.responseTime = System.currentTimeMillis() - start;
                }
            }
            catch (SocketException e) {
                LOG.info((Object)("shutting down receiver (" + e + ")"));
            }
            catch (IOException e) {
                LOG.info((Object)"connection exception; closing connection", (Throwable)e);
            }
            finally {
                this.end();
            }
        }
        LOG.info((Object)("Stopping: " + this.toString()));
    }

    private void end() {
        this.connection = null;
        this.poolToReturnTo.returnWorker(this);
    }

    public void debug(DebugString debug) {
        debug.appendln("context Id", (Object)this.debugContextId);
        debug.appendln("session", (Object)this.debugSession);
        debug.appendln("request", (Object)this.debugRequest);
        debug.appendln("response", (Object)this.debugResponse);
        debug.appendln("duration", (Object)((float)this.responseTime / 1000.0f + " secs."));
    }

    public String toString() {
        return "Worker#" + this.id;
    }
}

