/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.shared.encoding.object;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.remoting.shared.NakedObjectsRemoteException;
import org.nakedobjects.remoting.shared.data.Data;
import org.nakedobjects.remoting.shared.data.DataFactory;
import org.nakedobjects.remoting.shared.data.DataFactoryImpl;
import org.nakedobjects.remoting.shared.data.KnownObjects;
import org.nakedobjects.remoting.shared.encoding.object.ObjectEncoder;
import org.nakedobjects.remoting.shared.encoding.object.ObjectEncoderDataStructure;
import org.nakedobjects.remoting.shared.encoding.object.ObjectEncoderDeserializer;
import org.nakedobjects.remoting.shared.encoding.object.ObjectEncoderSerializer;
import org.nakedobjects.remoting.shared.encoding.object.data.ClientActionResultData;
import org.nakedobjects.remoting.shared.encoding.object.data.CollectionData;
import org.nakedobjects.remoting.shared.encoding.object.data.EncodeableObjectData;
import org.nakedobjects.remoting.shared.encoding.object.data.IdentityData;
import org.nakedobjects.remoting.shared.encoding.object.data.NullData;
import org.nakedobjects.remoting.shared.encoding.object.data.ObjectData;
import org.nakedobjects.remoting.shared.encoding.object.data.ReferenceData;
import org.nakedobjects.remoting.shared.encoding.object.data.ServerActionResultData;
import org.nakedobjects.remoting.shared.encoding.query.PersistenceQueryEncoder;
import org.nakedobjects.remoting.shared.encoding.query.PersistenceQueryFindAllInstancesEncoder;
import org.nakedobjects.remoting.shared.encoding.query.PersistenceQueryFindByPatternEncoder;
import org.nakedobjects.remoting.shared.encoding.query.PersistenceQueryFindByTitleEncoder;
import org.nakedobjects.remoting.shared.encoding.query.PersistenceQueryFindUsingApplibQueryDefaultEncoder;
import org.nakedobjects.remoting.shared.encoding.query.PersistenceQueryFindUsingApplibQuerySerializableEncoder;
import org.nakedobjects.remoting.shared.encoding.query.data.PersistenceQueryData;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistorUtil;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectEncoderDefault
implements ObjectEncoder {
    private final ObjectEncoderSerializer encoder = new ObjectEncoderSerializer();
    private final ObjectEncoderDeserializer decoder = new ObjectEncoderDeserializer();
    private final ObjectEncoderDataStructure dataStructure = new ObjectEncoderDataStructure();
    private final Map<Class<?>, PersistenceQueryEncoder> persistenceEncoderByClass = new HashMap();
    private DataFactory dataFactory;
    private int actionGraphDepth = 0;
    private int persistentGraphDepth = 100;
    private int updateGraphDepth = 1;

    public ObjectEncoderDefault() {
        this.encoder.setDataStructure(this.dataStructure);
        this.decoder.setDataStructure(this.dataStructure);
        this.addPersistenceQueryEncoder(new PersistenceQueryFindAllInstancesEncoder());
        this.addPersistenceQueryEncoder(new PersistenceQueryFindByTitleEncoder());
        this.addPersistenceQueryEncoder(new PersistenceQueryFindByPatternEncoder());
        this.addPersistenceQueryEncoder(new PersistenceQueryFindUsingApplibQueryDefaultEncoder());
        this.addPersistenceQueryEncoder(new PersistenceQueryFindUsingApplibQuerySerializableEncoder());
        this.dataFactory = new DataFactoryImpl();
    }

    public void addPersistenceQueryEncoder(PersistenceQueryEncoder encoder) {
        encoder.setObjectEncoder(this);
        this.persistenceEncoderByClass.put(encoder.getPersistenceQueryClass(), encoder);
    }

    @Override
    public ReferenceData encodeActionTarget(NakedObject target, KnownObjects knownObjects) {
        return this.encoder.serializeObject(this.dataFactory, target, this.actionGraphDepth, knownObjects);
    }

    @Override
    public ClientActionResultData encodeClientActionResult(ReferenceData[] madePersistent, Version[] changedVersion, ObjectData[] updates) {
        return this.dataFactory.createClientActionResultData(madePersistent, changedVersion, updates);
    }

    @Override
    public final ObjectData encodeCompletePersistentGraph(NakedObject object) {
        return (ObjectData)this.encoder.serializeObject(this.dataFactory, object, this.persistentGraphDepth, new KnownObjects());
    }

    @Override
    public PersistenceQueryData encodePersistenceQuery(PersistenceQuery criteria) {
        PersistenceQueryEncoder strategy = this.findPersistenceQueryEncoder(criteria.getClass());
        return strategy.encode(criteria);
    }

    @Override
    public Data encodeForResolveField(NakedObject adapter, String fieldName) {
        Oid oid = adapter.getOid();
        NakedObjectSpecification specification = adapter.getSpecification();
        String type = specification.getFullName();
        ResolveState resolveState = adapter.getResolveState();
        NakedObjectAssociation[] fields = this.getFieldOrder(specification);
        Data[] fieldContent = new Data[fields.length];
        PersistorUtil.start((NakedObject)adapter, (ResolveState)adapter.getResolveState().serializeFrom());
        KnownObjects knownObjects = new KnownObjects();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getId().equals(fieldName)) continue;
            NakedObject field = fields[i].get(adapter);
            if (field == null) {
                fieldContent[i] = this.dataFactory.createNullData(fields[i].getSpecification().getFullName());
                break;
            }
            if (fields[i].getSpecification().isEncodeable()) {
                fieldContent[i] = this.encoder.serializeEncodeable(this.dataFactory, field);
                break;
            }
            if (fields[i].isOneToManyAssociation()) {
                fieldContent[i] = this.encoder.serializeCollection(this.dataFactory, field, this.persistentGraphDepth, knownObjects);
                break;
            }
            NakedObjectsContext.getPersistenceSession().resolveImmediately(field);
            fieldContent[i] = this.encoder.serializeObject(this.dataFactory, field, this.persistentGraphDepth, knownObjects);
            break;
        }
        PersistorUtil.end((NakedObject)adapter);
        ObjectData data = this.dataFactory.createObjectData(type, oid, resolveState.isResolved(), adapter.getVersion());
        data.setFieldContent(fieldContent);
        return data;
    }

    @Override
    public ObjectData encodeForUpdate(NakedObject object) {
        ResolveState resolveState = object.getResolveState();
        if (resolveState.isSerializing() || resolveState.isGhost()) {
            throw new NakedObjectsRemoteException("Illegal resolve state: " + object);
        }
        return (ObjectData)this.encoder.serializeObject(this.dataFactory, object, this.updateGraphDepth, new KnownObjects());
    }

    @Override
    public ObjectData encodeGraphForChangedObject(NakedObject object, KnownObjects knownObjects) {
        return (ObjectData)this.encoder.serializeObject(this.dataFactory, object, 1, knownObjects);
    }

    @Override
    public final IdentityData encodeIdentityData(NakedObject object) {
        Assert.assertNotNull((String)"OID needed for reference", (Object)object, (Object)object.getOid());
        return this.dataFactory.createIdentityData(object.getSpecification().getFullName(), object.getOid(), object.getVersion());
    }

    private Data createMadePersistentCollection(CollectionData collectionData, NakedObject collection) {
        ReferenceData[] elementData = collectionData.getElements();
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        Iterator elements = facet.iterator(collection);
        for (int i = 0; i < elementData.length; ++i) {
            NakedObject element = (NakedObject)elements.next();
            Oid oid = element.getOid();
            Assert.assertNotNull((Object)oid);
            elementData[i] = this.encodeMadePersistentGraph((ObjectData)elementData[i], element);
        }
        return collectionData;
    }

    @Override
    public ObjectData encodeMadePersistentGraph(ObjectData data, NakedObject object) {
        Oid objectsOid = object.getOid();
        Assert.assertNotNull((Object)objectsOid);
        if (objectsOid.hasPrevious()) {
            Version version = object.getVersion();
            String type = data.getType();
            ObjectData persistedData = this.dataFactory.createObjectData(type, objectsOid, true, version);
            Data[] allContents = data.getFieldContent();
            if (allContents != null) {
                int contentLength = allContents.length;
                Data[] persistentContents = new Data[contentLength];
                NakedObjectAssociation[] fields = this.getFieldOrder(object.getSpecification());
                for (int i = 0; i < contentLength; ++i) {
                    NakedObject fieldReference;
                    Data fieldData = allContents[i];
                    if (fieldData instanceof NullData) {
                        persistentContents[i] = null;
                        continue;
                    }
                    if (fields[i].isOneToOneAssociation()) {
                        if (fieldData instanceof ObjectData) {
                            fieldReference = fields[i].get(object);
                            persistentContents[i] = this.encodeMadePersistentGraph((ObjectData)fieldData, fieldReference);
                            continue;
                        }
                        persistentContents[i] = null;
                        continue;
                    }
                    if (!fields[i].isOneToManyAssociation()) continue;
                    fieldReference = fields[i].get(object);
                    persistentContents[i] = this.createMadePersistentCollection((CollectionData)fieldData, fieldReference);
                }
                persistedData.setFieldContent(persistentContents);
            }
            return persistedData;
        }
        return null;
    }

    @Override
    public ObjectData encodeMakePersistentGraph(NakedObject adapter, KnownObjects knownObjects) {
        Assert.assertTrue((String)"transient", (boolean)adapter.isTransient());
        return (ObjectData)this.encoder.serializeObject(this.dataFactory, adapter, 1, knownObjects);
    }

    private final Data createParameter(String type, NakedObject object, KnownObjects knownObjects) {
        if (object == null) {
            return this.dataFactory.createNullData(type);
        }
        if (object.getSpecification().isObject()) {
            if (object.getSpecification().isEncodeable()) {
                return this.encoder.serializeEncodeable(this.dataFactory, object);
            }
            NakedObject nakedObject = object;
            return this.encoder.serializeObject(this.dataFactory, nakedObject, 0, knownObjects);
        }
        throw new UnknownTypeException((Object)object.getSpecification());
    }

    @Override
    public final Data[] encodeActionParameters(NakedObjectSpecification[] parameterTypes, NakedObject[] parameters, KnownObjects knownObjects) {
        Data[] parameterData = new Data[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            NakedObject parameter = parameters[i];
            String type = parameterTypes[i].getFullName();
            parameterData[i] = this.createParameter(type, parameter, knownObjects);
        }
        return parameterData;
    }

    @Override
    public ServerActionResultData encodeServerActionResult(NakedObject result, ObjectData[] updates, ReferenceData[] disposed, ObjectData persistedTarget, ObjectData[] persistedParameters, String[] messages, String[] warnings) {
        Data result1;
        if (result == null) {
            result1 = this.dataFactory.createNullData("");
        } else if (result.getSpecification().isCollection()) {
            result1 = this.encoder.serializeCollection(this.dataFactory, result, this.persistentGraphDepth, new KnownObjects());
        } else if (result.getSpecification().isObject()) {
            result1 = this.encodeCompletePersistentGraph(result);
        } else {
            throw new UnknownTypeException((Object)result);
        }
        return this.dataFactory.createServerActionResultData(result1, updates, disposed, persistedTarget, persistedParameters, messages, warnings);
    }

    @Override
    public EncodeableObjectData encodeAsValue(NakedObject value) {
        return this.encoder.serializeEncodeable(this.dataFactory, value);
    }

    public ObjectData createObject(NakedObject object) {
        return (ObjectData)this.encoder.serializeObject(this.dataFactory, object, 0, new KnownObjects());
    }

    @Override
    public NakedObjectAssociation[] getFieldOrder(NakedObjectSpecification specification) {
        return this.dataStructure.getFields(specification);
    }

    @Override
    public void madePersistent(NakedObject target, ObjectData persistedTarget) {
        this.decoder.madePersistent(target, persistedTarget);
    }

    @Override
    public NakedObject decode(Data data) {
        return this.decoder.restore(data);
    }

    @Override
    public NakedObject decode(Data data, KnownObjects knownObjects) {
        return this.decoder.restore(data, knownObjects);
    }

    @Override
    public PersistenceQuery decodePersistenceQuery(PersistenceQueryData persistenceQueryData) {
        Class<?> criteriaClass = persistenceQueryData.getPersistenceQueryClass();
        PersistenceQueryEncoder encoder = this.findPersistenceQueryEncoder(criteriaClass);
        return encoder.decode(persistenceQueryData);
    }

    private PersistenceQueryEncoder findPersistenceQueryEncoder(Class<?> persistenceQueryClass) {
        PersistenceQueryEncoder encoder = this.persistenceEncoderByClass.get(persistenceQueryClass);
        if (encoder == null) {
            throw new NakedObjectsRemoteException("No encoder for " + persistenceQueryClass.getName());
        }
        return encoder;
    }

    public void setActionGraphDepth(int actionGraphDepth) {
        this.actionGraphDepth = actionGraphDepth;
    }

    public void setDataFactory(DataFactory factory) {
        this.dataFactory = factory;
    }

    public void setPersistentGraphDepth(int persistentGraphDepth) {
        this.persistentGraphDepth = persistentGraphDepth;
    }

    public void setUpdateGraphDepth(int updateGraphDepth) {
        this.updateGraphDepth = updateGraphDepth;
    }
}

