/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.shared.encoding.object.data;

import java.io.Serializable;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.remoting.shared.data.Data;
import org.nakedobjects.remoting.shared.encoding.object.data.ObjectData;

public class ObjectDataImpl
implements ObjectData,
Encodable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Data[] fieldContent;
    private final Oid oid;
    private final boolean resolved;
    private final String type;
    private final Version version;

    public ObjectDataImpl(Oid oid, String type, boolean resolved, Version version) {
        this.oid = oid;
        this.type = type;
        this.resolved = resolved;
        this.version = version;
    }

    public ObjectDataImpl(ByteDecoder decoder) {
        this.type = decoder.getString();
        this.oid = (Oid)decoder.getObject();
        this.version = (Version)decoder.getObject();
        this.resolved = decoder.getBoolean();
        this.fieldContent = (Data[])decoder.getObjects();
    }

    public void encode(ByteEncoder encoder) {
        encoder.add(this.type);
        encoder.add((Object)this.oid);
        encoder.add((Object)this.version);
        encoder.add(this.resolved);
        encoder.add((Object[])this.fieldContent);
    }

    public Data[] getFieldContent() {
        return this.fieldContent;
    }

    public Oid getOid() {
        return this.oid;
    }

    public String getType() {
        return this.type;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean hasCompleteData() {
        return this.resolved;
    }

    public void setFieldContent(Data[] fieldContent) {
        this.fieldContent = fieldContent;
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("type", this.type);
        str.append("oid", (Object)this.oid);
        str.append("version", (Object)this.version);
        str.append(",fields=");
        for (int i = 0; this.fieldContent != null && i < this.fieldContent.length; ++i) {
            if (i > 0) {
                str.append(";");
            }
            if (this.fieldContent[i] == null) {
                str.append("null");
                continue;
            }
            String name = this.fieldContent[i].getClass().getName();
            str.append(name.substring(name.lastIndexOf(46) + 1));
        }
        return str.toString();
    }
}

