/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.client;

import org.easymock.MockControl;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.remoting.NakedObjectsRemoteException;
import org.nakedobjects.remoting.client.ClientConnection;
import org.nakedobjects.remoting.data.DummyIdentityData;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.data.common.ObjectData;
import org.nakedobjects.remoting.exchange.ClearAssociationRequest;
import org.nakedobjects.remoting.exchange.ClearAssociationResponse;
import org.nakedobjects.remoting.exchange.HasInstancesRequest;
import org.nakedobjects.remoting.exchange.HasInstancesResponse;
import org.nakedobjects.remoting.exchange.OidForServiceRequest;
import org.nakedobjects.remoting.exchange.OidForServiceResponse;
import org.nakedobjects.remoting.exchange.Request;
import org.nakedobjects.remoting.exchange.RequestAbstract;
import org.nakedobjects.remoting.exchange.ResponseEnvelope;
import org.nakedobjects.remoting.facade.ServerFacade;
import org.nakedobjects.remoting.facade.proxy.ServerFacadeProxy;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;
import org.nakedobjects.runtime.testsystem.TestProxyOid;
import org.nakedobjects.runtime.testsystem.TestProxySession;

public class CommandClientTest
extends ProxyJunit3TestCase {
    private MockControl control;
    private ServerFacade serverFacade;
    private ServerFacadeProxy serverFacadeProxy;
    private TestProxySession session;

    protected void setUp() throws Exception {
        super.setUp();
        this.control = MockControl.createControl(ServerFacade.class);
        this.serverFacade = (ServerFacade)this.control.getMock();
        ClientConnection connection = new ClientConnection(){

            public ResponseEnvelope executeRemotely(Request request) {
                request.execute(CommandClientTest.this.serverFacade);
                return new ResponseEnvelope(request);
            }

            public void init() {
            }

            public void shutdown() {
            }
        };
        this.serverFacadeProxy = new ServerFacadeProxy(connection);
        this.session = new TestProxySession();
    }

    public void testOidForService() {
        OidForServiceRequest request = new OidForServiceRequest((AuthenticationSession)this.session, "domain.Service");
        this.serverFacade.oidForService(request);
        DummyIdentityData data = new DummyIdentityData();
        this.control.setReturnValue((Object)new OidForServiceResponse((IdentityData)data));
        this.control.replay();
        OidForServiceResponse response = this.serverFacadeProxy.oidForService(request);
        IdentityData ret = response.getOidData();
        this.control.verify();
        CommandClientTest.assertEquals((Object)data, (Object)ret);
    }

    public void testHasInstances() {
        HasInstancesRequest request = new HasInstancesRequest((AuthenticationSession)this.session, "pkg.Class");
        this.serverFacade.hasInstances(request);
        boolean data = true;
        this.control.setReturnValue((Object)new HasInstancesResponse(true));
        this.control.replay();
        HasInstancesResponse response = this.serverFacadeProxy.hasInstances(request);
        boolean ret = response.hasInstances();
        this.control.verify();
        CommandClientTest.assertEquals((boolean)true, (boolean)ret);
    }

    public void testOutOfSequence() {
        ClientConnection connection = new ClientConnection(){

            public ResponseEnvelope executeRemotely(Request request) {
                return new ResponseEnvelope((Request)new RequestAbstract(null){
                    private static final long serialVersionUID = 1L;

                    public void execute(ServerFacade serverFacade) {
                    }
                });
            }

            public void init() {
            }

            public void shutdown() {
            }
        };
        this.serverFacadeProxy = new ServerFacadeProxy(connection);
        try {
            OidForServiceRequest request = new OidForServiceRequest((AuthenticationSession)this.session, "domain.Service");
            this.serverFacadeProxy.oidForService(request);
            CommandClientTest.fail();
        }
        catch (NakedObjectsRemoteException e) {
            CommandClientTest.assertTrue((boolean)e.getMessage().startsWith("Response out of sequence"));
        }
    }

    public void testClearAssociation() {
        DummyIdentityData target = new DummyIdentityData((Oid)new TestProxyOid(1), "class 1", null);
        DummyIdentityData associate = new DummyIdentityData((Oid)new TestProxyOid(2), "class 2", null);
        ClearAssociationRequest request = new ClearAssociationRequest((AuthenticationSession)this.session, "fieldname", (IdentityData)target, (IdentityData)associate);
        this.serverFacade.clearAssociation(request);
        ObjectData[] data = new ObjectData[2];
        this.control.setReturnValue((Object)new ClearAssociationResponse(data));
        this.control.replay();
        ClearAssociationResponse response = this.serverFacadeProxy.clearAssociation(request);
        ObjectData[] ret = response.getUpdates();
        this.control.verify();
        CommandClientTest.assertEquals((Object)data, (Object)ret);
    }
}

