/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.client;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.DomainObjectContainer;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.NakedObjectList;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.metamodel.services.ServicesInjectorDefault;
import org.nakedobjects.metamodel.services.container.DomainObjectContainerDefault;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.remoting.client.TestCriteria;
import org.nakedobjects.remoting.client.persistence.ClientSideTransactionManager;
import org.nakedobjects.remoting.client.persistence.PersistenceSessionProxy;
import org.nakedobjects.remoting.data.Data;
import org.nakedobjects.remoting.data.DummyEncodeableObjectData;
import org.nakedobjects.remoting.data.DummyIdentityData;
import org.nakedobjects.remoting.data.DummyNullValue;
import org.nakedobjects.remoting.data.DummyObjectData;
import org.nakedobjects.remoting.data.DummyReferenceData;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.data.common.ObjectData;
import org.nakedobjects.remoting.data.common.ReferenceData;
import org.nakedobjects.remoting.data.query.PersistenceQueryData;
import org.nakedobjects.remoting.exchange.ExecuteClientActionRequest;
import org.nakedobjects.remoting.exchange.ExecuteClientActionResponse;
import org.nakedobjects.remoting.exchange.FindInstancesRequest;
import org.nakedobjects.remoting.exchange.HasInstancesRequest;
import org.nakedobjects.remoting.exchange.KnownObjectsRequest;
import org.nakedobjects.remoting.exchange.ResolveObjectRequest;
import org.nakedobjects.remoting.facade.ServerFacade;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoder;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.PersistenceSessionTransactionManagement;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adapterfactory.pojo.PojoAdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerDefault;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerProxy;
import org.nakedobjects.runtime.persistence.internal.RuntimeContextFromSession;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactory;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactoryBasic;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryFindAllInstances;
import org.nakedobjects.runtime.testdomain.Movie;
import org.nakedobjects.runtime.testdomain.Person;
import org.nakedobjects.runtime.testspec.MovieSpecification;
import org.nakedobjects.runtime.testsystem.ProxyJunit4TestCase;
import org.nakedobjects.runtime.testsystem.TestProxyNakedObject;
import org.nakedobjects.runtime.testsystem.TestProxyOid;
import org.nakedobjects.runtime.testsystem.TestProxyOidGenerator;
import org.nakedobjects.runtime.testsystem.TestProxyVersion;

@RunWith(value=JMock.class)
public class ProxyPersistorTest
extends ProxyJunit4TestCase {
    private Mockery mockery = new JUnit4Mockery();
    private PersistenceSessionFactory mockPersistenceSessionFactory;
    private ServerFacade mockDistribution;
    private ObjectEncoderDecoder mockEncoder;
    private PersistenceSessionProxy persistenceSessionProxy;
    private ClientSideTransactionManager transactionManager;
    private AuthenticationSession session;
    private AdapterManagerExtended adapterManager;
    private AdapterFactory adapterFactory;
    private ObjectFactory objectFactory;
    private OidGenerator oidGenerator;

    @Before
    public void setUp() throws Exception {
        this.mockPersistenceSessionFactory = (PersistenceSessionFactory)this.mockery.mock(PersistenceSessionFactory.class);
        this.mockDistribution = (ServerFacade)this.mockery.mock(ServerFacade.class);
        this.mockEncoder = (ObjectEncoderDecoder)this.mockery.mock(ObjectEncoderDecoder.class);
        this.adapterManager = new AdapterManagerDefault();
        this.adapterFactory = new PojoAdapterFactory();
        this.objectFactory = new ObjectFactoryBasic();
        this.oidGenerator = new TestProxyOidGenerator();
        RuntimeContextFromSession runtimeContext = new RuntimeContextFromSession();
        DomainObjectContainerDefault container = new DomainObjectContainerDefault();
        runtimeContext.injectInto((Object)container);
        runtimeContext.setContainer((DomainObjectContainer)container);
        ServicesInjectorDefault servicesInjector = new ServicesInjectorDefault();
        servicesInjector.setContainer((DomainObjectContainer)container);
        this.persistenceSessionProxy = new PersistenceSessionProxy(this.mockPersistenceSessionFactory, this.adapterFactory, this.objectFactory, (ServicesInjector)servicesInjector, this.oidGenerator, this.adapterManager, this.mockDistribution, this.mockEncoder);
        this.persistenceSessionProxy.setSpecificationLoader((SpecificationLoader)this.system.getReflector());
        this.transactionManager = new ClientSideTransactionManager((AdapterManagerProxy)this.adapterManager, (PersistenceSessionTransactionManagement)this.persistenceSessionProxy, this.mockDistribution, this.mockEncoder);
        this.transactionManager.injectInto((Object)this.persistenceSessionProxy);
        this.session = NakedObjectsContext.getAuthenticationSession();
        this.system.setPersistenceSession((PersistenceSession)this.persistenceSessionProxy);
        this.ignoreCallsToInitializeMocks();
        this.persistenceSessionProxy.open();
    }

    @After
    public void tearDown() throws Exception {
    }

    private static SpecificationLoader getSpecificationLoader() {
        return NakedObjectsContext.getSpecificationLoader();
    }

    @Test
    public void testClientSideMakesNoRemoteCallsWhenNoWorkNeeded() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                this.never(ProxyPersistorTest.this.mockDistribution);
            }
        });
        this.transactionManager.startTransaction();
        this.transactionManager.endTransaction();
    }

    @Ignore(value="need to get working after refactoring")
    @Test
    public void testFindInstances() throws Exception {
        final DummyObjectData instanceData = new DummyObjectData((Oid)new TestProxyOid(12, true), Movie.class.getName(), true, (Version)new TestProxyVersion(3));
        final TestProxyNakedObject dummyNakedObject = new TestProxyNakedObject();
        dummyNakedObject.setupObject((Object)new Movie());
        dummyNakedObject.setupSpecification((NakedObjectSpecification)new MovieSpecification());
        final TestCriteria c = new TestCriteria();
        NakedObjectSpecification noSpec = ProxyPersistorTest.getSpecificationLoader().loadSpecification(Movie.class);
        final PersistenceQueryFindAllInstances criteria = new PersistenceQueryFindAllInstances(noSpec);
        final FindInstancesRequest request = new FindInstancesRequest(this.session, (PersistenceQueryData)c);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectEncoderDecoder)this.one(ProxyPersistorTest.this.mockEncoder)).decode((Data)instanceData);
                this.will(2.returnValue((Object)dummyNakedObject));
                ((ServerFacade)this.one(ProxyPersistorTest.this.mockDistribution)).findInstances(request);
                this.will(2.returnValue((Object)new ObjectData[]{instanceData}));
                ((ObjectEncoderDecoder)this.one(ProxyPersistorTest.this.mockEncoder)).encodePersistenceQuery((PersistenceQuery)criteria);
                this.will(2.returnValue((Object)c));
            }
        });
        NakedObject instances = this.persistenceSessionProxy.findInstances((PersistenceQuery)criteria);
        NakedObjectList objects = (NakedObjectList)instances.getObject();
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertEquals((Object)dummyNakedObject, objects.elements().nextElement());
    }

    @Test
    public void testResolveImmediatelyIgnoredWhenAlreadyResolving() throws Exception {
        TestProxyNakedObject object = new TestProxyNakedObject();
        object.setupResolveState(ResolveState.RESOLVING);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                this.never(ProxyPersistorTest.this.mockDistribution);
            }
        });
        this.persistenceSessionProxy.resolveImmediately((NakedObject)object);
    }

    @Ignore(value="need to get working after refactoring")
    @Test
    public void testResolveImmediately() throws Exception {
        final TestProxyNakedObject object = new TestProxyNakedObject();
        object.setupOid((Oid)new TestProxyOid(5));
        object.setupResolveState(ResolveState.GHOST);
        final DummyReferenceData identityData = new DummyReferenceData();
        final DummyObjectData objectData = new DummyObjectData();
        final ResolveObjectRequest request = new ResolveObjectRequest(this.session, (IdentityData)identityData);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectEncoderDecoder)this.one(ProxyPersistorTest.this.mockEncoder)).encodeIdentityData((NakedObject)object);
                this.will(4.returnValue((Object)identityData));
                ((ServerFacade)this.one(ProxyPersistorTest.this.mockDistribution)).resolveImmediately(request);
                this.will(4.returnValue((Object)objectData));
                ((ObjectEncoderDecoder)this.one(ProxyPersistorTest.this.mockEncoder)).decode((Data)objectData);
                this.will(4.returnValue(null));
            }
        });
        this.persistenceSessionProxy.resolveImmediately((NakedObject)object);
    }

    @Ignore(value="TODO")
    @Test
    public void testResolveField_TBI() {
    }

    @Ignore(value="need to get working after refactoring")
    @Test
    public void testHasInstances() throws Exception {
        final HasInstancesRequest request = new HasInstancesRequest(this.session, Movie.class.getName());
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ServerFacade)this.one(ProxyPersistorTest.this.mockDistribution)).hasInstances(request);
                this.will(5.returnValue((Object)true));
                ((ServerFacade)this.one(ProxyPersistorTest.this.mockDistribution)).hasInstances(request);
                this.will(5.returnValue((Object)false));
            }
        });
        NakedObjectSpecification type = ProxyPersistorTest.getSpecificationLoader().loadSpecification(Movie.class);
        Assert.assertTrue((boolean)this.persistenceSessionProxy.hasInstances(type));
        Assert.assertFalse((boolean)this.persistenceSessionProxy.hasInstances(type));
    }

    public void testFindInstancesButNoneFound() throws Exception {
        final TestCriteria c = new TestCriteria();
        NakedObjectSpecification noSpec = ProxyPersistorTest.getSpecificationLoader().loadSpecification(Movie.class);
        final PersistenceQueryFindAllInstances criteria = new PersistenceQueryFindAllInstances(noSpec);
        final FindInstancesRequest request = new FindInstancesRequest(this.session, (PersistenceQueryData)c);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ServerFacade)this.one(ProxyPersistorTest.this.mockDistribution)).findInstances(request);
                this.will(6.returnValue((Object)new ObjectData[0]));
                ((ObjectEncoderDecoder)this.one(ProxyPersistorTest.this.mockEncoder)).encodePersistenceQuery((PersistenceQuery)criteria);
                this.will(6.returnValue((Object)c));
            }
        });
        this.persistenceSessionProxy.findInstances((PersistenceQuery)criteria);
    }

    @Test(expected=IllegalStateException.class)
    public void testClientSideActionThrowsExceptionWhenTransactionNotStarted() throws Exception {
        this.transactionManager.endTransaction();
    }

    @Test
    public void testClientSideActionWhereObjectDeleted() throws Exception {
        final NakedObject movieAdapter = this.system.createPersistentTestObject();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                DummyIdentityData identityOfObjectToDelete = this.encoderShouldCreateIdentityDataForMovie(movieAdapter);
                this.distributionShouldExecuteClientActionForDeletedMovie(identityOfObjectToDelete);
            }

            private DummyIdentityData encoderShouldCreateIdentityDataForMovie(NakedObject movieAdapter2) {
                DummyIdentityData identityOfObjectToDelete = new DummyIdentityData();
                ((ObjectEncoderDecoder)this.one(ProxyPersistorTest.this.mockEncoder)).encodeIdentityData(movieAdapter2);
                this.will(7.returnValue((Object)identityOfObjectToDelete));
                return identityOfObjectToDelete;
            }

            private void distributionShouldExecuteClientActionForDeletedMovie(DummyIdentityData identityOfObjectToDelete) {
                Version[] versionUpdates = new Version[]{};
                ((ServerFacade)this.one(ProxyPersistorTest.this.mockDistribution)).executeClientAction((ExecuteClientActionRequest)this.with(7.any(ExecuteClientActionRequest.class)));
                this.will(7.returnValue((Object)new ExecuteClientActionResponse((ReferenceData[])new ObjectData[0], versionUpdates, new ObjectData[0])));
            }
        });
        this.transactionManager.startTransaction();
        this.persistenceSessionProxy.destroyObject(movieAdapter);
        this.transactionManager.endTransaction();
        List allDisposedObjects = NakedObjectsContext.getUpdateNotifier().getDisposedObjects();
        Assert.assertFalse((boolean)allDisposedObjects.isEmpty());
        Assert.assertEquals((Object)movieAdapter, allDisposedObjects.get(0));
    }

    @Test
    public void testClientSideActionWhereObjectChanged() throws Exception {
        final TestProxyNakedObject directorAdapter = new TestProxyNakedObject();
        directorAdapter.setupResolveState(ResolveState.RESOLVED);
        final TestProxyNakedObject movieAdapter = new TestProxyNakedObject();
        movieAdapter.setupResolveState(ResolveState.RESOLVED);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                DummyObjectData movieData = this.encoderShouldCreateGraphForChangedMovie(movieAdapter);
                DummyObjectData directorData = this.encoderShouldCreateGraphForChangedDirector(directorAdapter);
                this.distributionShouldExecuteClientActionForBothChangedObjects(movieData, directorData);
            }

            private DummyObjectData encoderShouldCreateGraphForChangedMovie(TestProxyNakedObject movieAdapter2) {
                DummyObjectData movieData = new DummyObjectData((Oid)new TestProxyOid(12, true), Movie.class.getName(), true, (Version)new TestProxyVersion(4));
                DummyEncodeableObjectData expectedMovieName = new DummyEncodeableObjectData("War of the Worlds", String.class.getName());
                DummyReferenceData expectedDirectorRef = new DummyReferenceData((Oid)new TestProxyOid(14, true), Person.class.getName(), (Version)new TestProxyVersion(8));
                movieData.setFieldContent(new Data[]{expectedDirectorRef, expectedMovieName});
                ((ObjectEncoderDecoder)this.one(ProxyPersistorTest.this.mockEncoder)).encodeGraphForChangedObject((NakedObject)movieAdapter2, new KnownObjectsRequest());
                this.will(8.returnValue((Object)movieData));
                return movieData;
            }

            private DummyObjectData encoderShouldCreateGraphForChangedDirector(TestProxyNakedObject directorAdapter2) {
                DummyObjectData directorData = new DummyObjectData((Oid)new TestProxyOid(14, true), Person.class.getName(), true, (Version)new TestProxyVersion(8));
                DummyEncodeableObjectData expectedDirectorName = new DummyEncodeableObjectData("Unknown", String.class.getName());
                directorData.setFieldContent(new Data[]{expectedDirectorName});
                ((ObjectEncoderDecoder)this.one(ProxyPersistorTest.this.mockEncoder)).encodeGraphForChangedObject((NakedObject)directorAdapter2, new KnownObjectsRequest());
                this.will(8.returnValue((Object)directorData));
                return directorData;
            }

            private void distributionShouldExecuteClientActionForBothChangedObjects(DummyObjectData movieData, DummyObjectData directorData) {
                ObjectData[] changes = new ObjectData[]{movieData, directorData};
                int[] types = new int[]{2, 2};
                ((ServerFacade)this.one(ProxyPersistorTest.this.mockDistribution)).executeClientAction((ExecuteClientActionRequest)this.with(8.any(ExecuteClientActionRequest.class)));
                Version[] versionUpdates = new Version[]{new TestProxyVersion(5), new TestProxyVersion(9)};
                this.will(8.returnValue((Object)new ExecuteClientActionResponse((ReferenceData[])new ObjectData[]{movieData, directorData}, versionUpdates, new ObjectData[0])));
            }
        });
        this.transactionManager.startTransaction();
        this.persistenceSessionProxy.objectChanged((NakedObject)movieAdapter);
        this.persistenceSessionProxy.objectChanged((NakedObject)directorAdapter);
        this.transactionManager.endTransaction();
        Assert.assertEquals((Object)new TestProxyVersion(5), (Object)movieAdapter.getVersion());
        Assert.assertEquals((Object)new TestProxyVersion(9), (Object)directorAdapter.getVersion());
    }

    @Test
    public void testClientSideActionWhereTransientObjectMadePersistent() throws Exception {
        final NakedObject transientObject = this.system.createTransientTestObject();
        final TestProxyOid previousOid = (TestProxyOid)transientObject.getOid();
        final DummyObjectData movieData = new DummyObjectData((Oid)previousOid, Movie.class.getName(), true, null);
        DummyNullValue directorData = new DummyNullValue(Person.class.getName());
        DummyEncodeableObjectData nameData = new DummyEncodeableObjectData("Star Wars", String.class.getName());
        movieData.setFieldContent(new Data[]{directorData, nameData});
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                TestProxyOid newOid = new TestProxyOid(123, true);
                newOid.setupPrevious(previousOid);
                DummyReferenceData updateData = new DummyReferenceData((Oid)newOid, "type", (Version)new TestProxyVersion(456));
                ((ServerFacade)this.one(ProxyPersistorTest.this.mockDistribution)).executeClientAction((ExecuteClientActionRequest)this.with(9.any(ExecuteClientActionRequest.class)));
                this.will(9.returnValue((Object)new ExecuteClientActionResponse(new ReferenceData[]{updateData}, null, new ObjectData[0])));
            }
        });
        ProxyPersistorTest.getAdapterManager().adapterFor(transientObject.getObject());
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectEncoderDecoder)this.one(ProxyPersistorTest.this.mockEncoder)).encodeMakePersistentGraph((NakedObject)this.with(CoreMatchers.equalTo((Object)transientObject)), (KnownObjectsRequest)this.with(10.any(KnownObjectsRequest.class)));
                this.will(10.returnValue((Object)movieData));
            }
        });
        this.transactionManager.startTransaction();
        this.persistenceSessionProxy.makePersistent(transientObject);
        this.transactionManager.endTransaction();
    }

    private void ignoreCallsToInitializeMocks() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ServerFacade)this.ignoring(ProxyPersistorTest.this.mockDistribution)).init();
            }
        });
    }

    private void ignoreCallsToDistribution() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(ProxyPersistorTest.this.mockDistribution);
            }
        });
    }
}

