/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.protocol.encoding;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.exceptions.NotYetImplementedException;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacetAbstract;
import org.nakedobjects.metamodel.testspec.TestProxySpecification;
import org.nakedobjects.remoting.data.Data;
import org.nakedobjects.remoting.data.DummyCollectionData;
import org.nakedobjects.remoting.data.DummyObjectData;
import org.nakedobjects.remoting.data.common.ObjectData;
import org.nakedobjects.remoting.data.common.ReferenceData;
import org.nakedobjects.remoting.protocol.encoding.internal.FieldOrderCache;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectDeserializer;
import org.nakedobjects.runtime.persistence.adaptermanager.ObjectToNakedObjectTransformer;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;
import org.nakedobjects.runtime.testsystem.TestPojo;
import org.nakedobjects.runtime.testsystem.TestProxyOid;
import org.nakedobjects.runtime.testsystem.TestProxyVersion;

public class ObjectDecoderCollectionTest
extends ProxyJunit3TestCase {
    private ObjectDeserializer deserializer;

    protected void setUp() throws Exception {
        super.setUp();
        FieldOrderCache fieldOrderCache = null;
        this.deserializer = new ObjectDeserializer(fieldOrderCache);
        TestProxySpecification specification = this.system.getSpecification(Vector.class);
        specification.addFacet((Facet)new CollectionFacetAbstract((FacetHolder)specification){

            public void init(NakedObject collection, NakedObject[] initData) {
                for (int i = 0; i < initData.length; ++i) {
                    this.collectionOfUnderlying(collection).add(initData[i].getObject());
                }
            }

            public Collection<NakedObject> collection(NakedObject nakedObjectRepresentingCollection) {
                Collection<Object> collection = this.collectionOfUnderlying(nakedObjectRepresentingCollection);
                return CollectionUtils.collect(collection, (Transformer)new ObjectToNakedObjectTransformer());
            }

            public NakedObject firstElement(NakedObject collection) {
                throw new NotYetImplementedException();
            }

            public int size(NakedObject collection) {
                return this.collectionOfUnderlying(collection).size();
            }

            private Collection<Object> collectionOfUnderlying(NakedObject collectionNO) {
                return (Collection)collectionNO.getObject();
            }
        });
    }

    public void testRecreateEmptyCollection() {
        TestProxyOid collectionOid = new TestProxyOid(123);
        ReferenceData[] elementData = null;
        DummyCollectionData data = new DummyCollectionData((Oid)collectionOid, Vector.class.getName(), TestPojo.class.getName(), elementData, (Version)new TestProxyVersion());
        NakedObject naked = this.deserializer.deserialize((Data)data);
        Vector restoredCollection = (Vector)naked.getObject();
        ObjectDecoderCollectionTest.assertEquals((int)0, (int)restoredCollection.size());
        CollectionFacet facet = (CollectionFacet)naked.getSpecification().getFacet(CollectionFacet.class);
        ObjectDecoderCollectionTest.assertEquals((int)0, (int)facet.size(naked));
    }

    public void testRecreateCollection() {
        ObjectData[] elements = new ObjectData[2];
        TestProxyOid element0Oid = new TestProxyOid(345, true);
        elements[0] = new DummyObjectData((Oid)element0Oid, TestPojo.class.getName(), false, (Version)new TestProxyVersion(3));
        TestProxyOid element1Oid = new TestProxyOid(678, true);
        elements[1] = new DummyObjectData((Oid)element1Oid, TestPojo.class.getName(), false, (Version)new TestProxyVersion(7));
        TestProxyOid collectionOid = new TestProxyOid(123);
        DummyCollectionData data = new DummyCollectionData((Oid)collectionOid, Vector.class.getName(), TestPojo.class.getName(), (ReferenceData[])elements, (Version)new TestProxyVersion());
        NakedObject naked = this.deserializer.deserialize((Data)data);
        Vector restoredCollection = (Vector)naked.getObject();
        ObjectDecoderCollectionTest.assertEquals((int)2, (int)restoredCollection.size());
        CollectionFacet facet = (CollectionFacet)naked.getSpecification().getFacet(CollectionFacet.class);
        Enumeration elements2 = facet.elements(naked);
        NakedObject element0 = (NakedObject)elements2.nextElement();
        NakedObject element2 = (NakedObject)elements2.nextElement();
        ObjectDecoderCollectionTest.assertNotNull((Object)element0.getObject());
        ObjectDecoderCollectionTest.assertNotNull((Object)element2.getObject());
        ObjectDecoderCollectionTest.assertEquals(TestPojo.class, element0.getObject().getClass());
        ObjectDecoderCollectionTest.assertEquals(TestPojo.class, element2.getObject().getClass());
        ObjectDecoderCollectionTest.assertEquals((Object)new TestProxyOid(678, true), (Object)element2.getOid());
        ObjectDecoderCollectionTest.assertEquals((Object)new TestProxyOid(345, true), (Object)element0.getOid());
    }
}

