/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.protocol.encoding;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodableFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.remoting.data.Data;
import org.nakedobjects.remoting.data.DummyEncodeableObjectData;
import org.nakedobjects.remoting.data.DummyNullValue;
import org.nakedobjects.remoting.data.DummyObjectData;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoderDefault;
import org.nakedobjects.runtime.testdomain.Movie;
import org.nakedobjects.runtime.testdomain.Person;
import org.nakedobjects.runtime.testspec.MovieSpecification;
import org.nakedobjects.runtime.testspec.PersonSpecification;
import org.nakedobjects.runtime.testsystem.ProxyJunit4TestCase;
import org.nakedobjects.runtime.testsystem.TestProxyOid;
import org.nakedobjects.runtime.testsystem.TestProxyVersion;

public class ObjectEncoderImplTest
extends ProxyJunit4TestCase {
    private ObjectEncoderDecoderDefault encoder;

    @Before
    public void setUp() throws Exception {
        this.encoder = new ObjectEncoderDecoderDefault();
        this.system.addSpecification((NakedObjectSpecification)new MovieSpecification());
        this.system.addSpecification((NakedObjectSpecification)new PersonSpecification());
        this.system.getSpecification(String.class).setupIsEncodeable();
        this.system.getSpecification(String.class).addFacet((Facet)new EncodableFacet(){

            public String toEncodedString(NakedObject object) {
                return object.getObject().toString();
            }

            public NakedObject fromEncodedString(String encodedData) {
                return ObjectEncoderImplTest.getAdapterManager().adapterFor((Object)encodedData);
            }

            public Class<? extends Facet> facetType() {
                return EncodableFacet.class;
            }

            public FacetHolder getFacetHolder() {
                return null;
            }

            public void setFacetHolder(FacetHolder facetHolder) {
            }

            public boolean alwaysReplace() {
                return false;
            }

            public boolean isDerived() {
                return false;
            }

            public boolean isNoop() {
                return false;
            }

            public Facet getUnderlyingFacet() {
                return null;
            }

            public void setUnderlyingFacet(Facet underlyingFacet) {
                throw new UnsupportedOperationException();
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        this.system.shutdown();
    }

    @Test
    public void testRestoreCreatesNewAdapter() {
        DummyObjectData data = new DummyObjectData((Oid)new TestProxyOid(5, true), Movie.class.getName(), true, (Version)new TestProxyVersion(3));
        DummyEncodeableObjectData name = new DummyEncodeableObjectData("ET", "java.lang.String");
        DummyNullValue reference = new DummyNullValue(Person.class.getName());
        data.setFieldContent(new Data[]{reference, name});
        NakedObject object = this.encoder.decode((Data)data);
        Assert.assertTrue((boolean)(object.getObject() instanceof Movie));
        Movie movie = (Movie)object.getObject();
        Assert.assertEquals((Object)"ET", (Object)movie.getName());
        Assert.assertEquals((Object)new TestProxyOid(5, true), (Object)object.getOid());
        Assert.assertEquals((Object)new TestProxyVersion(3), (Object)object.getVersion());
    }

    @Test
    public void testRestoreCreatesNewAdapterInUnresolvedState() {
        DummyObjectData data = new DummyObjectData((Oid)new TestProxyOid(5, true), Movie.class.getName(), false, (Version)new TestProxyVersion(3));
        NakedObject object = this.encoder.decode((Data)data);
        Assert.assertTrue((boolean)(object.getObject() instanceof Movie));
        Assert.assertEquals((Object)new TestProxyOid(5, true), (Object)object.getOid());
        Assert.assertEquals(null, (Object)object.getVersion());
    }

    @Test
    public void testRestoreUpdatesExistingAdapter() {
        Movie movie = new Movie();
        NakedObject adapter = this.system.createPersistentTestObject((Object)movie);
        adapter.changeState(ResolveState.RESOLVED);
        DummyObjectData data = new DummyObjectData(adapter.getOid(), Movie.class.getName(), true, (Version)new TestProxyVersion(3));
        DummyEncodeableObjectData name = new DummyEncodeableObjectData("ET", "java.lang.String");
        DummyNullValue reference = new DummyNullValue(Person.class.getName());
        data.setFieldContent(new Data[]{reference, name});
        ObjectEncoderImplTest.getTransactionManager().startTransaction();
        NakedObject object = this.encoder.decode((Data)data);
        ObjectEncoderImplTest.getTransactionManager().endTransaction();
        Assert.assertEquals((Object)new TestProxyVersion(3), (Object)object.getVersion());
        Assert.assertEquals((Object)"ET", (Object)movie.getName());
        Assert.assertEquals((Object)movie, (Object)object.getObject());
    }

    @Test
    public void testRestoreIgnoredIfNoFieldData() {
        Movie movie = new Movie();
        NakedObject adapter = this.system.createPersistentTestObject((Object)movie);
        adapter.changeState(ResolveState.RESOLVED);
        DummyObjectData data = new DummyObjectData(adapter.getOid(), Movie.class.getName(), false, (Version)new TestProxyVersion(3));
        NakedObject object = this.encoder.decode((Data)data);
        Assert.assertEquals((Object)movie, (Object)object.getObject());
        Assert.assertEquals((Object)new TestProxyVersion(1), (Object)object.getVersion());
    }

    @Test
    public void testRestoreTransientObject() {
        DummyObjectData movieData = new DummyObjectData((Oid)new TestProxyOid(-1), Movie.class.getName(), true, null);
        DummyNullValue directorData = new DummyNullValue(Person.class.getName());
        DummyEncodeableObjectData nameData = new DummyEncodeableObjectData("Star Wars", String.class.getName());
        movieData.setFieldContent(new Data[]{directorData, nameData});
        NakedObject object = this.encoder.decode((Data)movieData);
        Movie movie = (Movie)object.getObject();
        Assert.assertEquals((Object)movie, (Object)object.getObject());
        Assert.assertEquals((Object)new TestProxyOid(-1), (Object)object.getOid());
        Assert.assertEquals((Object)ResolveState.TRANSIENT, (Object)object.getResolveState());
        Assert.assertEquals(null, (Object)object.getVersion());
    }
}

