/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.server;

import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodableFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.testspec.TestProxySpecification;
import org.nakedobjects.remoting.data.DummyEncodeableObjectData;
import org.nakedobjects.remoting.data.DummyReferenceData;
import org.nakedobjects.remoting.data.common.EncodableObjectData;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.data.common.ObjectData;
import org.nakedobjects.remoting.exchange.ClearValueRequest;
import org.nakedobjects.remoting.exchange.ClearValueResponse;
import org.nakedobjects.remoting.exchange.SetValueRequest;
import org.nakedobjects.remoting.exchange.SetValueResponse;
import org.nakedobjects.remoting.facade.impl.ServerFacadeImpl;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoder;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;
import org.nakedobjects.runtime.testsystem.ProxyJunit4TestCase;
import org.nakedobjects.runtime.testsystem.TestProxyAssociation;
import org.nakedobjects.runtime.testsystem.TestProxyVersion;

@RunWith(value=JMock.class)
public class ServerFacadeImpl_ParseableAssociationsTest
extends ProxyJunit4TestCase {
    private Mockery mockery = new JUnit4Mockery();
    private ServerFacadeImpl server;
    private AuthenticationSession session;
    private DummyReferenceData movieData;
    private NakedObject object;
    private TestProxyAssociation nameField;
    private AuthenticationManager mockAuthenticationManager;
    private ObjectEncoderDecoder mockObjectEncoder;

    @Before
    public void setUp() throws Exception {
        this.mockAuthenticationManager = (AuthenticationManager)this.mockery.mock(AuthenticationManager.class);
        this.mockObjectEncoder = (ObjectEncoderDecoder)this.mockery.mock(ObjectEncoderDecoder.class);
        this.server = new ServerFacadeImpl(this.mockAuthenticationManager);
        this.server.setEncoder(this.mockObjectEncoder);
        this.server.init();
        this.object = this.system.createPersistentTestObject();
        TestProxySpecification spec = (TestProxySpecification)this.object.getSpecification();
        this.nameField = new TestProxyAssociation("name", this.system.getSpecification(String.class));
        spec.setupFields(new NakedObjectAssociation[]{this.nameField});
        this.movieData = new DummyReferenceData(this.object.getOid(), "none", (Version)new TestProxyVersion(1));
    }

    @After
    public void tearDown() throws Exception {
        this.system.shutdown();
    }

    @Test
    public void testClearAssociation() {
        NakedObjectsContext.getTransactionManager().startTransaction();
        ClearValueRequest request = new ClearValueRequest(this.session, "name", (IdentityData)this.movieData);
        ClearValueResponse response = this.server.clearValue(request);
        ObjectData[] updatesData = response.getUpdates();
        NakedObjectsContext.getTransactionManager().endTransaction();
        this.nameField.assertFieldEmpty(this.object);
        Assert.assertEquals((long)0L, (long)updatesData.length);
    }

    @Test
    public void testSetValue() {
        TestProxySpecification specf = this.system.getSpecification(String.class);
        specf.addFacet((Facet)new EncodableFacet(){

            public String toEncodedString(NakedObject object) {
                return null;
            }

            public NakedObject fromEncodedString(String encodedData) {
                return ServerFacadeImpl_ParseableAssociationsTest.getAdapterManager().adapterFor((Object)new String(encodedData));
            }

            public Class facetType() {
                return EncodableFacet.class;
            }

            public FacetHolder getFacetHolder() {
                return null;
            }

            public void setFacetHolder(FacetHolder facetHolder) {
            }

            public boolean alwaysReplace() {
                return false;
            }

            public boolean isDerived() {
                return false;
            }

            public boolean isNoop() {
                return false;
            }

            public Facet getUnderlyingFacet() {
                return null;
            }

            public void setUnderlyingFacet(Facet underlyingFacet) {
                throw new UnsupportedOperationException();
            }
        });
        NakedObjectsContext.getTransactionManager().startTransaction();
        SetValueRequest request = new SetValueRequest(this.session, "name", (IdentityData)this.movieData, (EncodableObjectData)new DummyEncodeableObjectData("name of movie"));
        SetValueResponse response = this.server.setValue(request);
        ObjectData[] updates = response.getUpdates();
        NakedObjectsContext.getTransactionManager().endTransaction();
        this.nameField.assertField((Object)this.object, (Object)"name of movie");
        Assert.assertEquals((long)0L, (long)updates.length);
    }

    @Test
    public void testSetAssociationFailsWithNonCurrentTarget() {
        try {
            this.object.setOptimisticLock((Version)new TestProxyVersion(2));
            SetValueRequest request = new SetValueRequest(this.session, "name", (IdentityData)this.movieData, (EncodableObjectData)new DummyEncodeableObjectData("name of movie"));
            this.server.setValue(request);
            Assert.fail();
        }
        catch (ConcurrencyException concurrencyException) {
            // empty catch block
        }
    }

    @Test
    public void testSetAssociationFailsWhenInvisible() {
        this.nameField.setUpIsVisible(false);
        try {
            SetValueRequest request = new SetValueRequest(this.session, "name", (IdentityData)this.movieData, (EncodableObjectData)new DummyEncodeableObjectData("name of movie"));
            this.server.setValue(request);
            Assert.fail();
        }
        catch (NakedObjectException expected) {
            Assert.assertEquals((Object)"can't modify field as not visible or editable", (Object)expected.getMessage());
        }
    }

    @Test
    public void testSetAssociationFailsWhenUnavailable() {
        this.nameField.setUpIsUnusableFor(this.object);
        try {
            SetValueRequest request = new SetValueRequest(this.session, "name", (IdentityData)this.movieData, (EncodableObjectData)new DummyEncodeableObjectData("test data"));
            this.server.setValue(request);
            Assert.fail();
        }
        catch (NakedObjectException expected) {
            Assert.assertEquals((Object)"can't modify field as not visible or editable", (Object)expected.getMessage());
        }
    }
}

